package io.codegen.gwt.jsonoverlay.processor.model.types;

import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new OptionalType.Builder()}.
 */
@Generated(from = "OptionalType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableOptionalType
    implements OptionalType {
  private final JavaType elementType;
  private final JavaType.Kind kind;

  private ImmutableOptionalType(
      JavaType elementType,
      JavaType.Kind kind) {
    this.elementType = elementType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code elementType} attribute
   */
  @Override
  public JavaType getElementType() {
    return elementType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalType#getElementType() elementType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalType withElementType(JavaType value) {
    if (this.elementType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "elementType");
    return new ImmutableOptionalType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionalType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionalType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableOptionalType(this.elementType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalType
        && equalTo((ImmutableOptionalType) another);
  }

  private boolean equalTo(ImmutableOptionalType another) {
    return elementType.equals(another.elementType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code elementType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + elementType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OptionalType{"
        + "elementType=" + elementType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OptionalType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalType instance
   */
  public static ImmutableOptionalType copyOf(OptionalType instance) {
    if (instance instanceof ImmutableOptionalType) {
      return (ImmutableOptionalType) instance;
    }
    return new OptionalType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalType ImmutableOptionalType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_ELEMENT_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private JavaType elementType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableOptionalType ImmutableOptionalType} instances.
     */
    public Builder() {
      if (!(this instanceof OptionalType.Builder)) {
        throw new UnsupportedOperationException("Use: new OptionalType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final OptionalType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (OptionalType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.OptionalType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final OptionalType.Builder from(OptionalType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (OptionalType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof OptionalType) {
        OptionalType instance = (OptionalType) object;
        elementType(instance.getElementType());
      }
    }

    /**
     * Initializes the value for the {@link OptionalType#getElementType() elementType} attribute.
     * @param elementType The value for elementType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final OptionalType.Builder elementType(JavaType elementType) {
      this.elementType = Objects.requireNonNull(elementType, "elementType");
      initBits &= ~INIT_BIT_ELEMENT_TYPE;
      return (OptionalType.Builder) this;
    }

    /**
     * Initializes the value for the {@link OptionalType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final OptionalType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (OptionalType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableOptionalType ImmutableOptionalType}.
     * @return An immutable instance of OptionalType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableOptionalType(elementType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ELEMENT_TYPE) != 0) attributes.add("elementType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build OptionalType, some of required attributes are not set " + attributes;
    }
  }
}
