package io.codegen.gwt.jsonoverlay.processor.model.types;

import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MapType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new MapType.Builder()}.
 */
@Generated(from = "MapType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMapType implements MapType {
  private final JavaType valueType;
  private final JavaType.Kind kind;

  private ImmutableMapType(
      JavaType valueType,
      JavaType.Kind kind) {
    this.valueType = valueType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code valueType} attribute
   */
  @Override
  public JavaType getValueType() {
    return valueType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapType#getValueType() valueType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapType withValueType(JavaType value) {
    if (this.valueType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "valueType");
    return new ImmutableMapType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MapType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMapType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableMapType(this.valueType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMapType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMapType
        && equalTo((ImmutableMapType) another);
  }

  private boolean equalTo(ImmutableMapType another) {
    return valueType.equals(another.valueType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code valueType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + valueType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MapType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapType{"
        + "valueType=" + valueType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MapType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MapType instance
   */
  public static ImmutableMapType copyOf(MapType instance) {
    if (instance instanceof ImmutableMapType) {
      return (ImmutableMapType) instance;
    }
    return new MapType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMapType ImmutableMapType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MapType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_VALUE_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private JavaType valueType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableMapType ImmutableMapType} instances.
     */
    public Builder() {
      if (!(this instanceof MapType.Builder)) {
        throw new UnsupportedOperationException("Use: new MapType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final MapType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (MapType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.MapType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final MapType.Builder from(MapType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (MapType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof MapType) {
        MapType instance = (MapType) object;
        valueType(instance.getValueType());
      }
    }

    /**
     * Initializes the value for the {@link MapType#getValueType() valueType} attribute.
     * @param valueType The value for valueType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final MapType.Builder valueType(JavaType valueType) {
      this.valueType = Objects.requireNonNull(valueType, "valueType");
      initBits &= ~INIT_BIT_VALUE_TYPE;
      return (MapType.Builder) this;
    }

    /**
     * Initializes the value for the {@link MapType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final MapType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (MapType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableMapType ImmutableMapType}.
     * @return An immutable instance of MapType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMapType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMapType(valueType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE_TYPE) != 0) attributes.add("valueType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build MapType, some of required attributes are not set " + attributes;
    }
  }
}
