package io.codegen.gwt.jsonoverlay.processor.model.types;

import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ListType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ListType.Builder()}.
 */
@Generated(from = "ListType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableListType implements ListType {
  private final JavaType elementType;
  private final JavaType.Kind kind;

  private ImmutableListType(
      JavaType elementType,
      JavaType.Kind kind) {
    this.elementType = elementType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code elementType} attribute
   */
  @Override
  public JavaType getElementType() {
    return elementType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ListType#getElementType() elementType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableListType withElementType(JavaType value) {
    if (this.elementType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "elementType");
    return new ImmutableListType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ListType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableListType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableListType(this.elementType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableListType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableListType
        && equalTo((ImmutableListType) another);
  }

  private boolean equalTo(ImmutableListType another) {
    return elementType.equals(another.elementType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code elementType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + elementType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListType{"
        + "elementType=" + elementType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ListType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ListType instance
   */
  public static ImmutableListType copyOf(ListType instance) {
    if (instance instanceof ImmutableListType) {
      return (ImmutableListType) instance;
    }
    return new ListType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableListType ImmutableListType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ListType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_ELEMENT_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private JavaType elementType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableListType ImmutableListType} instances.
     */
    public Builder() {
      if (!(this instanceof ListType.Builder)) {
        throw new UnsupportedOperationException("Use: new ListType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final ListType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (ListType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.ListType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final ListType.Builder from(ListType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (ListType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof ListType) {
        ListType instance = (ListType) object;
        elementType(instance.getElementType());
      }
    }

    /**
     * Initializes the value for the {@link ListType#getElementType() elementType} attribute.
     * @param elementType The value for elementType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ListType.Builder elementType(JavaType elementType) {
      this.elementType = Objects.requireNonNull(elementType, "elementType");
      initBits &= ~INIT_BIT_ELEMENT_TYPE;
      return (ListType.Builder) this;
    }

    /**
     * Initializes the value for the {@link ListType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final ListType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (ListType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableListType ImmutableListType}.
     * @return An immutable instance of ListType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableListType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableListType(elementType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ELEMENT_TYPE) != 0) attributes.add("elementType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build ListType, some of required attributes are not set " + attributes;
    }
  }
}
