package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.TypeName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaScriptObjectType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaScriptObjectType.Builder()}.
 */
@Generated(from = "JavaScriptObjectType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaScriptObjectType
    implements JavaScriptObjectType {
  private final TypeName javaScriptObjectType;
  private final JavaType.Kind kind;

  private ImmutableJavaScriptObjectType(
      TypeName javaScriptObjectType,
      JavaType.Kind kind) {
    this.javaScriptObjectType = javaScriptObjectType;
    this.kind = kind;
  }

  /**
   * @return the type of the JavaScriptObject, usually com.google.gwt.core.client.JavaScriptObject
   */
  @Override
  public TypeName getJavaScriptObjectType() {
    return javaScriptObjectType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaScriptObjectType#getJavaScriptObjectType() javaScriptObjectType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for javaScriptObjectType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaScriptObjectType withJavaScriptObjectType(TypeName value) {
    if (this.javaScriptObjectType == value) return this;
    TypeName newValue = Objects.requireNonNull(value, "javaScriptObjectType");
    return new ImmutableJavaScriptObjectType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaScriptObjectType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaScriptObjectType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableJavaScriptObjectType(this.javaScriptObjectType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaScriptObjectType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaScriptObjectType
        && equalTo((ImmutableJavaScriptObjectType) another);
  }

  private boolean equalTo(ImmutableJavaScriptObjectType another) {
    return javaScriptObjectType.equals(another.javaScriptObjectType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code javaScriptObjectType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + javaScriptObjectType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavaScriptObjectType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaScriptObjectType{"
        + "javaScriptObjectType=" + javaScriptObjectType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaScriptObjectType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaScriptObjectType instance
   */
  public static ImmutableJavaScriptObjectType copyOf(JavaScriptObjectType instance) {
    if (instance instanceof ImmutableJavaScriptObjectType) {
      return (ImmutableJavaScriptObjectType) instance;
    }
    return new JavaScriptObjectType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaScriptObjectType ImmutableJavaScriptObjectType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaScriptObjectType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_JAVA_SCRIPT_OBJECT_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private TypeName javaScriptObjectType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableJavaScriptObjectType ImmutableJavaScriptObjectType} instances.
     */
    public Builder() {
      if (!(this instanceof JavaScriptObjectType.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaScriptObjectType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaScriptObjectType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (JavaScriptObjectType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.JavaScriptObjectType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaScriptObjectType.Builder from(JavaScriptObjectType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (JavaScriptObjectType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof JavaScriptObjectType) {
        JavaScriptObjectType instance = (JavaScriptObjectType) object;
        javaScriptObjectType(instance.getJavaScriptObjectType());
      }
    }

    /**
     * Initializes the value for the {@link JavaScriptObjectType#getJavaScriptObjectType() javaScriptObjectType} attribute.
     * @param javaScriptObjectType The value for javaScriptObjectType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaScriptObjectType.Builder javaScriptObjectType(TypeName javaScriptObjectType) {
      this.javaScriptObjectType = Objects.requireNonNull(javaScriptObjectType, "javaScriptObjectType");
      initBits &= ~INIT_BIT_JAVA_SCRIPT_OBJECT_TYPE;
      return (JavaScriptObjectType.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaScriptObjectType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaScriptObjectType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (JavaScriptObjectType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaScriptObjectType ImmutableJavaScriptObjectType}.
     * @return An immutable instance of JavaScriptObjectType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaScriptObjectType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaScriptObjectType(javaScriptObjectType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_JAVA_SCRIPT_OBJECT_TYPE) != 0) attributes.add("javaScriptObjectType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build JavaScriptObjectType, some of required attributes are not set " + attributes;
    }
  }
}
