package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.ClassName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link InheritedType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new InheritedType.Builder()}.
 */
@Generated(from = "InheritedType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableInheritedType
    implements InheritedType {
  private final String discriminatorMethodName;
  private final ClassName superType;
  private final Map<String, JavaType> inheritedTypes;
  private final JavaType.Kind kind;

  private ImmutableInheritedType(
      String discriminatorMethodName,
      ClassName superType,
      Map<String, JavaType> inheritedTypes,
      JavaType.Kind kind) {
    this.discriminatorMethodName = discriminatorMethodName;
    this.superType = superType;
    this.inheritedTypes = inheritedTypes;
    this.kind = kind;
  }

  /**
   * @return the name of the discriminator method
   */
  @Override
  public String getDiscriminatorMethodName() {
    return discriminatorMethodName;
  }

  /**
   * @return the classname of the super type
   */
  @Override
  public ClassName getSuperType() {
    return superType;
  }

  /**
   * @return map of the inherited {@link JavaType types} by their discriminator
   */
  @Override
  public Map<String, JavaType> getInheritedTypes() {
    return inheritedTypes;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InheritedType#getDiscriminatorMethodName() discriminatorMethodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for discriminatorMethodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInheritedType withDiscriminatorMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "discriminatorMethodName");
    if (this.discriminatorMethodName.equals(newValue)) return this;
    return new ImmutableInheritedType(newValue, this.superType, this.inheritedTypes, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InheritedType#getSuperType() superType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for superType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInheritedType withSuperType(ClassName value) {
    if (this.superType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "superType");
    return new ImmutableInheritedType(this.discriminatorMethodName, newValue, this.inheritedTypes, this.kind);
  }

  /**
   * Copy the current immutable object by replacing the {@link InheritedType#getInheritedTypes() inheritedTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the inheritedTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableInheritedType withInheritedTypes(Map<String, ? extends JavaType> entries) {
    if (this.inheritedTypes == entries) return this;
    Map<String, JavaType> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableInheritedType(this.discriminatorMethodName, this.superType, newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link InheritedType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableInheritedType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableInheritedType(this.discriminatorMethodName, this.superType, this.inheritedTypes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableInheritedType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableInheritedType
        && equalTo((ImmutableInheritedType) another);
  }

  private boolean equalTo(ImmutableInheritedType another) {
    return discriminatorMethodName.equals(another.discriminatorMethodName)
        && superType.equals(another.superType)
        && inheritedTypes.equals(another.inheritedTypes)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code discriminatorMethodName}, {@code superType}, {@code inheritedTypes}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + discriminatorMethodName.hashCode();
    h += (h << 5) + superType.hashCode();
    h += (h << 5) + inheritedTypes.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code InheritedType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "InheritedType{"
        + "discriminatorMethodName=" + discriminatorMethodName
        + ", superType=" + superType
        + ", inheritedTypes=" + inheritedTypes
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link InheritedType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable InheritedType instance
   */
  public static ImmutableInheritedType copyOf(InheritedType instance) {
    if (instance instanceof ImmutableInheritedType) {
      return (ImmutableInheritedType) instance;
    }
    return new InheritedType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableInheritedType ImmutableInheritedType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "InheritedType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_DISCRIMINATOR_METHOD_NAME = 0x1L;
    private static final long INIT_BIT_SUPER_TYPE = 0x2L;
    private static final long INIT_BIT_KIND = 0x4L;
    private long initBits = 0x7L;

    private String discriminatorMethodName;
    private ClassName superType;
    private Map<String, JavaType> inheritedTypes = new LinkedHashMap<String, JavaType>();
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableInheritedType ImmutableInheritedType} instances.
     */
    public Builder() {
      if (!(this instanceof InheritedType.Builder)) {
        throw new UnsupportedOperationException("Use: new InheritedType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.InheritedType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder from(InheritedType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (InheritedType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (InheritedType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof InheritedType) {
        InheritedType instance = (InheritedType) object;
        superType(instance.getSuperType());
        putAllInheritedTypes(instance.getInheritedTypes());
        discriminatorMethodName(instance.getDiscriminatorMethodName());
      }
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
    }

    /**
     * Initializes the value for the {@link InheritedType#getDiscriminatorMethodName() discriminatorMethodName} attribute.
     * @param discriminatorMethodName The value for discriminatorMethodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder discriminatorMethodName(String discriminatorMethodName) {
      this.discriminatorMethodName = Objects.requireNonNull(discriminatorMethodName, "discriminatorMethodName");
      initBits &= ~INIT_BIT_DISCRIMINATOR_METHOD_NAME;
      return (InheritedType.Builder) this;
    }

    /**
     * Initializes the value for the {@link InheritedType#getSuperType() superType} attribute.
     * @param superType The value for superType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder superType(ClassName superType) {
      this.superType = Objects.requireNonNull(superType, "superType");
      initBits &= ~INIT_BIT_SUPER_TYPE;
      return (InheritedType.Builder) this;
    }

    /**
     * Put one entry to the {@link InheritedType#getInheritedTypes() inheritedTypes} map.
     * @param key The key in the inheritedTypes map
     * @param value The associated value in the inheritedTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder putInheritedTypes(String key, JavaType value) {
      this.inheritedTypes.put(
          Objects.requireNonNull(key, "inheritedTypes key"),
          Objects.requireNonNull(value, "inheritedTypes value"));
      return (InheritedType.Builder) this;
    }

    /**
     * Put one entry to the {@link InheritedType#getInheritedTypes() inheritedTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder putInheritedTypes(Map.Entry<String, ? extends JavaType> entry) {
      String k = entry.getKey();
      JavaType v = entry.getValue();
      this.inheritedTypes.put(
          Objects.requireNonNull(k, "inheritedTypes key"),
          Objects.requireNonNull(v, "inheritedTypes value"));
      return (InheritedType.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link InheritedType#getInheritedTypes() inheritedTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inheritedTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder inheritedTypes(Map<String, ? extends JavaType> entries) {
      this.inheritedTypes.clear();
      return putAllInheritedTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link InheritedType#getInheritedTypes() inheritedTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the inheritedTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder putAllInheritedTypes(Map<String, ? extends JavaType> entries) {
      for (Map.Entry<String, ? extends JavaType> e : entries.entrySet()) {
        String k = e.getKey();
        JavaType v = e.getValue();
        this.inheritedTypes.put(
            Objects.requireNonNull(k, "inheritedTypes key"),
            Objects.requireNonNull(v, "inheritedTypes value"));
      }
      return (InheritedType.Builder) this;
    }

    /**
     * Initializes the value for the {@link InheritedType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final InheritedType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (InheritedType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableInheritedType ImmutableInheritedType}.
     * @return An immutable instance of InheritedType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableInheritedType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableInheritedType(discriminatorMethodName, superType, createUnmodifiableMap(false, false, inheritedTypes), kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISCRIMINATOR_METHOD_NAME) != 0) attributes.add("discriminatorMethodName");
      if ((initBits & INIT_BIT_SUPER_TYPE) != 0) attributes.add("superType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build InheritedType, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
