package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.ClassName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EnumType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new EnumType.Builder()}.
 */
@Generated(from = "EnumType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableEnumType implements EnumType {
  private final ClassName enumType;
  private final JavaType.Kind kind;

  private ImmutableEnumType(
      ClassName enumType,
      JavaType.Kind kind) {
    this.enumType = enumType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code enumType} attribute
   */
  @Override
  public ClassName getEnumType() {
    return enumType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnumType#getEnumType() enumType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for enumType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnumType withEnumType(ClassName value) {
    if (this.enumType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "enumType");
    return new ImmutableEnumType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EnumType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEnumType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableEnumType(this.enumType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEnumType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEnumType
        && equalTo((ImmutableEnumType) another);
  }

  private boolean equalTo(ImmutableEnumType another) {
    return enumType.equals(another.enumType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code enumType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + enumType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code EnumType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EnumType{"
        + "enumType=" + enumType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EnumType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EnumType instance
   */
  public static ImmutableEnumType copyOf(EnumType instance) {
    if (instance instanceof ImmutableEnumType) {
      return (ImmutableEnumType) instance;
    }
    return new EnumType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableEnumType ImmutableEnumType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EnumType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_ENUM_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private ClassName enumType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableEnumType ImmutableEnumType} instances.
     */
    public Builder() {
      if (!(this instanceof EnumType.Builder)) {
        throw new UnsupportedOperationException("Use: new EnumType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final EnumType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (EnumType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.EnumType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final EnumType.Builder from(EnumType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (EnumType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof EnumType) {
        EnumType instance = (EnumType) object;
        enumType(instance.getEnumType());
      }
    }

    /**
     * Initializes the value for the {@link EnumType#getEnumType() enumType} attribute.
     * @param enumType The value for enumType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final EnumType.Builder enumType(ClassName enumType) {
      this.enumType = Objects.requireNonNull(enumType, "enumType");
      initBits &= ~INIT_BIT_ENUM_TYPE;
      return (EnumType.Builder) this;
    }

    /**
     * Initializes the value for the {@link EnumType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final EnumType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (EnumType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableEnumType ImmutableEnumType}.
     * @return An immutable instance of EnumType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEnumType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableEnumType(enumType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ENUM_TYPE) != 0) attributes.add("enumType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build EnumType, some of required attributes are not set " + attributes;
    }
  }
}
