package io.codegen.gwt.jsonoverlay.processor.model.types;

import com.squareup.javapoet.ClassName;
import io.codegen.gwt.jsonoverlay.processor.model.JavaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BoxedType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new BoxedType.Builder()}.
 */
@Generated(from = "BoxedType", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableBoxedType implements BoxedType {
  private final ClassName boxedType;
  private final JavaType.Kind kind;

  private ImmutableBoxedType(
      ClassName boxedType,
      JavaType.Kind kind) {
    this.boxedType = boxedType;
    this.kind = kind;
  }

  /**
   * @return The value of the {@code boxedType} attribute
   */
  @Override
  public ClassName getBoxedType() {
    return boxedType;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @Override
  public JavaType.Kind getKind() {
    return kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BoxedType#getBoxedType() boxedType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for boxedType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBoxedType withBoxedType(ClassName value) {
    if (this.boxedType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "boxedType");
    return new ImmutableBoxedType(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BoxedType#getKind() kind} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBoxedType withKind(JavaType.Kind value) {
    if (this.kind == value) return this;
    JavaType.Kind newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableBoxedType(this.boxedType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBoxedType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBoxedType
        && equalTo((ImmutableBoxedType) another);
  }

  private boolean equalTo(ImmutableBoxedType another) {
    return boxedType.equals(another.boxedType)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code boxedType}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + boxedType.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BoxedType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BoxedType{"
        + "boxedType=" + boxedType
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link BoxedType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BoxedType instance
   */
  public static ImmutableBoxedType copyOf(BoxedType instance) {
    if (instance instanceof ImmutableBoxedType) {
      return (ImmutableBoxedType) instance;
    }
    return new BoxedType.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableBoxedType ImmutableBoxedType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BoxedType", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_BOXED_TYPE = 0x1L;
    private static final long INIT_BIT_KIND = 0x2L;
    private long initBits = 0x3L;

    private ClassName boxedType;
    private JavaType.Kind kind;

    /**
     * Creates a builder for {@link ImmutableBoxedType ImmutableBoxedType} instances.
     */
    public Builder() {
      if (!(this instanceof BoxedType.Builder)) {
        throw new UnsupportedOperationException("Use: new BoxedType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.JavaType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final BoxedType.Builder from(JavaType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (BoxedType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.codegen.gwt.jsonoverlay.processor.model.types.BoxedType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final BoxedType.Builder from(BoxedType instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (BoxedType.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof JavaType) {
        JavaType instance = (JavaType) object;
        kind(instance.getKind());
      }
      if (object instanceof BoxedType) {
        BoxedType instance = (BoxedType) object;
        boxedType(instance.getBoxedType());
      }
    }

    /**
     * Initializes the value for the {@link BoxedType#getBoxedType() boxedType} attribute.
     * @param boxedType The value for boxedType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final BoxedType.Builder boxedType(ClassName boxedType) {
      this.boxedType = Objects.requireNonNull(boxedType, "boxedType");
      initBits &= ~INIT_BIT_BOXED_TYPE;
      return (BoxedType.Builder) this;
    }

    /**
     * Initializes the value for the {@link BoxedType#getKind() kind} attribute.
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    public final BoxedType.Builder kind(JavaType.Kind kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      initBits &= ~INIT_BIT_KIND;
      return (BoxedType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableBoxedType ImmutableBoxedType}.
     * @return An immutable instance of BoxedType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBoxedType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBoxedType(boxedType, kind);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BOXED_TYPE) != 0) attributes.add("boxedType");
      if ((initBits & INIT_BIT_KIND) != 0) attributes.add("kind");
      return "Cannot build BoxedType, some of required attributes are not set " + attributes;
    }
  }
}
