package io.codegen.gwt.jsonoverlay.processor.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaInterface}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaInterface.Builder()}.
 */
@Generated(from = "JavaInterface", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaInterface implements JavaInterface {
  private final JavaType type;
  private final List<JavaGetter> getters;

  private ImmutableJavaInterface(
      JavaType type,
      List<JavaGetter> getters) {
    this.type = type;
    this.getters = getters;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public JavaType getType() {
    return type;
  }

  /**
   * @return The value of the {@code getters} attribute
   */
  @Override
  public List<JavaGetter> getGetters() {
    return getters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaInterface#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaInterface withType(JavaType value) {
    if (this.type == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "type");
    return new ImmutableJavaInterface(newValue, this.getters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaInterface#getGetters() getters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaInterface withGetters(JavaGetter... elements) {
    List<JavaGetter> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJavaInterface(this.type, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaInterface#getGetters() getters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of getters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaInterface withGetters(Iterable<? extends JavaGetter> elements) {
    if (this.getters == elements) return this;
    List<JavaGetter> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJavaInterface(this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaInterface} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaInterface
        && equalTo((ImmutableJavaInterface) another);
  }

  private boolean equalTo(ImmutableJavaInterface another) {
    return type.equals(another.type)
        && getters.equals(another.getters);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code getters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + getters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavaInterface} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaInterface{"
        + "type=" + type
        + ", getters=" + getters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaInterface} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaInterface instance
   */
  public static ImmutableJavaInterface copyOf(JavaInterface instance) {
    if (instance instanceof ImmutableJavaInterface) {
      return (ImmutableJavaInterface) instance;
    }
    return new JavaInterface.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaInterface ImmutableJavaInterface}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaInterface", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private JavaType type;
    private List<JavaGetter> getters = new ArrayList<JavaGetter>();

    /**
     * Creates a builder for {@link ImmutableJavaInterface ImmutableJavaInterface} instances.
     */
    public Builder() {
      if (!(this instanceof JavaInterface.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaInterface.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaInterface} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder from(JavaInterface instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      addAllGetters(instance.getGetters());
      return (JavaInterface.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaInterface#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder type(JavaType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return (JavaInterface.Builder) this;
    }

    /**
     * Adds one element to {@link JavaInterface#getGetters() getters} list.
     * @param element A getters element
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder addGetters(JavaGetter element) {
      this.getters.add(Objects.requireNonNull(element, "getters element"));
      return (JavaInterface.Builder) this;
    }

    /**
     * Adds elements to {@link JavaInterface#getGetters() getters} list.
     * @param elements An array of getters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder addGetters(JavaGetter... elements) {
      for (JavaGetter element : elements) {
        this.getters.add(Objects.requireNonNull(element, "getters element"));
      }
      return (JavaInterface.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link JavaInterface#getGetters() getters} list.
     * @param elements An iterable of getters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder getters(Iterable<? extends JavaGetter> elements) {
      this.getters.clear();
      return addAllGetters(elements);
    }

    /**
     * Adds elements to {@link JavaInterface#getGetters() getters} list.
     * @param elements An iterable of getters elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaInterface.Builder addAllGetters(Iterable<? extends JavaGetter> elements) {
      for (JavaGetter element : elements) {
        this.getters.add(Objects.requireNonNull(element, "getters element"));
      }
      return (JavaInterface.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaInterface ImmutableJavaInterface}.
     * @return An immutable instance of JavaInterface
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaInterface build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaInterface(type, createUnmodifiableList(true, getters));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build JavaInterface, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
