package io.codegen.gwt.jsonoverlay.processor.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaGetter}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaGetter.Builder()}.
 */
@Generated(from = "JavaGetter", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaGetter implements JavaGetter {
  private final String propertyName;
  private final String methodName;
  private final JavaType propertyType;
  private final boolean hasSetter;

  private ImmutableJavaGetter(
      String propertyName,
      String methodName,
      JavaType propertyType,
      boolean hasSetter) {
    this.propertyName = propertyName;
    this.methodName = methodName;
    this.propertyType = propertyType;
    this.hasSetter = hasSetter;
  }

  /**
   * @return the name of the property
   */
  @Override
  public String getPropertyName() {
    return propertyName;
  }

  /**
   * @return the name of the method
   */
  @Override
  public String getMethodName() {
    return methodName;
  }

  /**
   * @return the type of the property
   */
  @Override
  public JavaType getPropertyType() {
    return propertyType;
  }

  /**
   * @return The value of the {@code hasSetter} attribute
   */
  @Override
  public boolean hasSetter() {
    return hasSetter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaGetter#getPropertyName() propertyName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaGetter withPropertyName(String value) {
    String newValue = Objects.requireNonNull(value, "propertyName");
    if (this.propertyName.equals(newValue)) return this;
    return new ImmutableJavaGetter(newValue, this.methodName, this.propertyType, this.hasSetter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaGetter#getMethodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaGetter withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return new ImmutableJavaGetter(this.propertyName, newValue, this.propertyType, this.hasSetter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaGetter#getPropertyType() propertyType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaGetter withPropertyType(JavaType value) {
    if (this.propertyType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "propertyType");
    return new ImmutableJavaGetter(this.propertyName, this.methodName, newValue, this.hasSetter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaGetter#hasSetter() hasSetter} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hasSetter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaGetter withHasSetter(boolean value) {
    if (this.hasSetter == value) return this;
    return new ImmutableJavaGetter(this.propertyName, this.methodName, this.propertyType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaGetter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaGetter
        && equalTo((ImmutableJavaGetter) another);
  }

  private boolean equalTo(ImmutableJavaGetter another) {
    return propertyName.equals(another.propertyName)
        && methodName.equals(another.methodName)
        && propertyType.equals(another.propertyType)
        && hasSetter == another.hasSetter;
  }

  /**
   * Computes a hash code from attributes: {@code propertyName}, {@code methodName}, {@code propertyType}, {@code hasSetter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + propertyName.hashCode();
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + propertyType.hashCode();
    h += (h << 5) + Boolean.hashCode(hasSetter);
    return h;
  }

  /**
   * Prints the immutable value {@code JavaGetter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaGetter{"
        + "propertyName=" + propertyName
        + ", methodName=" + methodName
        + ", propertyType=" + propertyType
        + ", hasSetter=" + hasSetter
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaGetter} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaGetter instance
   */
  public static ImmutableJavaGetter copyOf(JavaGetter instance) {
    if (instance instanceof ImmutableJavaGetter) {
      return (ImmutableJavaGetter) instance;
    }
    return new JavaGetter.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaGetter ImmutableJavaGetter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaGetter", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_PROPERTY_NAME = 0x1L;
    private static final long INIT_BIT_METHOD_NAME = 0x2L;
    private static final long INIT_BIT_PROPERTY_TYPE = 0x4L;
    private static final long INIT_BIT_HAS_SETTER = 0x8L;
    private long initBits = 0xfL;

    private String propertyName;
    private String methodName;
    private JavaType propertyType;
    private boolean hasSetter;

    /**
     * Creates a builder for {@link ImmutableJavaGetter ImmutableJavaGetter} instances.
     */
    public Builder() {
      if (!(this instanceof JavaGetter.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaGetter.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaGetter} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaGetter.Builder from(JavaGetter instance) {
      Objects.requireNonNull(instance, "instance");
      propertyName(instance.getPropertyName());
      methodName(instance.getMethodName());
      propertyType(instance.getPropertyType());
      hasSetter(instance.hasSetter());
      return (JavaGetter.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaGetter#getPropertyName() propertyName} attribute.
     * @param propertyName The value for propertyName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaGetter.Builder propertyName(String propertyName) {
      this.propertyName = Objects.requireNonNull(propertyName, "propertyName");
      initBits &= ~INIT_BIT_PROPERTY_NAME;
      return (JavaGetter.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaGetter#getMethodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaGetter.Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return (JavaGetter.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaGetter#getPropertyType() propertyType} attribute.
     * @param propertyType The value for propertyType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaGetter.Builder propertyType(JavaType propertyType) {
      this.propertyType = Objects.requireNonNull(propertyType, "propertyType");
      initBits &= ~INIT_BIT_PROPERTY_TYPE;
      return (JavaGetter.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaGetter#hasSetter() hasSetter} attribute.
     * @param hasSetter The value for hasSetter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaGetter.Builder hasSetter(boolean hasSetter) {
      this.hasSetter = hasSetter;
      initBits &= ~INIT_BIT_HAS_SETTER;
      return (JavaGetter.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaGetter ImmutableJavaGetter}.
     * @return An immutable instance of JavaGetter
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaGetter build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaGetter(propertyName, methodName, propertyType, hasSetter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROPERTY_NAME) != 0) attributes.add("propertyName");
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_PROPERTY_TYPE) != 0) attributes.add("propertyType");
      if ((initBits & INIT_BIT_HAS_SETTER) != 0) attributes.add("hasSetter");
      return "Cannot build JavaGetter, some of required attributes are not set " + attributes;
    }
  }
}
