package io.codegen.gwt.jsonoverlay.processor.model;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaFactory}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaFactory.Builder()}.
 */
@Generated(from = "JavaFactory", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaFactory implements JavaFactory {
  private final ClassName type;
  private final List<JavaConvertMethod> convertMethods;
  private final List<JavaCreateMethod> createMethods;

  private ImmutableJavaFactory(
      ClassName type,
      List<JavaConvertMethod> convertMethods,
      List<JavaCreateMethod> createMethods) {
    this.type = type;
    this.convertMethods = convertMethods;
    this.createMethods = createMethods;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public ClassName getType() {
    return type;
  }

  /**
   * @return The value of the {@code convertMethods} attribute
   */
  @Override
  public List<JavaConvertMethod> getConvertMethods() {
    return convertMethods;
  }

  /**
   * @return The value of the {@code createMethods} attribute
   */
  @Override
  public List<JavaCreateMethod> getCreateMethods() {
    return createMethods;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaFactory#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaFactory withType(ClassName value) {
    if (this.type == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "type");
    return new ImmutableJavaFactory(newValue, this.convertMethods, this.createMethods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaFactory#getConvertMethods() convertMethods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaFactory withConvertMethods(JavaConvertMethod... elements) {
    List<JavaConvertMethod> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJavaFactory(this.type, newValue, this.createMethods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaFactory#getConvertMethods() convertMethods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of convertMethods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaFactory withConvertMethods(Iterable<? extends JavaConvertMethod> elements) {
    if (this.convertMethods == elements) return this;
    List<JavaConvertMethod> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJavaFactory(this.type, newValue, this.createMethods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaFactory#getCreateMethods() createMethods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaFactory withCreateMethods(JavaCreateMethod... elements) {
    List<JavaCreateMethod> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableJavaFactory(this.type, this.convertMethods, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JavaFactory#getCreateMethods() createMethods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of createMethods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJavaFactory withCreateMethods(Iterable<? extends JavaCreateMethod> elements) {
    if (this.createMethods == elements) return this;
    List<JavaCreateMethod> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableJavaFactory(this.type, this.convertMethods, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaFactory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaFactory
        && equalTo((ImmutableJavaFactory) another);
  }

  private boolean equalTo(ImmutableJavaFactory another) {
    return type.equals(another.type)
        && convertMethods.equals(another.convertMethods)
        && createMethods.equals(another.createMethods);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code convertMethods}, {@code createMethods}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + convertMethods.hashCode();
    h += (h << 5) + createMethods.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavaFactory} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaFactory{"
        + "type=" + type
        + ", convertMethods=" + convertMethods
        + ", createMethods=" + createMethods
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaFactory} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaFactory instance
   */
  public static ImmutableJavaFactory copyOf(JavaFactory instance) {
    if (instance instanceof ImmutableJavaFactory) {
      return (ImmutableJavaFactory) instance;
    }
    return new JavaFactory.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaFactory ImmutableJavaFactory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaFactory", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private ClassName type;
    private List<JavaConvertMethod> convertMethods = new ArrayList<JavaConvertMethod>();
    private List<JavaCreateMethod> createMethods = new ArrayList<JavaCreateMethod>();

    /**
     * Creates a builder for {@link ImmutableJavaFactory ImmutableJavaFactory} instances.
     */
    public Builder() {
      if (!(this instanceof JavaFactory.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaFactory.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaFactory} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder from(JavaFactory instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      addAllConvertMethods(instance.getConvertMethods());
      addAllCreateMethods(instance.getCreateMethods());
      return (JavaFactory.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaFactory#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder type(ClassName type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return (JavaFactory.Builder) this;
    }

    /**
     * Adds one element to {@link JavaFactory#getConvertMethods() convertMethods} list.
     * @param element A convertMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addConvertMethods(JavaConvertMethod element) {
      this.convertMethods.add(Objects.requireNonNull(element, "convertMethods element"));
      return (JavaFactory.Builder) this;
    }

    /**
     * Adds elements to {@link JavaFactory#getConvertMethods() convertMethods} list.
     * @param elements An array of convertMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addConvertMethods(JavaConvertMethod... elements) {
      for (JavaConvertMethod element : elements) {
        this.convertMethods.add(Objects.requireNonNull(element, "convertMethods element"));
      }
      return (JavaFactory.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link JavaFactory#getConvertMethods() convertMethods} list.
     * @param elements An iterable of convertMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder convertMethods(Iterable<? extends JavaConvertMethod> elements) {
      this.convertMethods.clear();
      return addAllConvertMethods(elements);
    }

    /**
     * Adds elements to {@link JavaFactory#getConvertMethods() convertMethods} list.
     * @param elements An iterable of convertMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addAllConvertMethods(Iterable<? extends JavaConvertMethod> elements) {
      for (JavaConvertMethod element : elements) {
        this.convertMethods.add(Objects.requireNonNull(element, "convertMethods element"));
      }
      return (JavaFactory.Builder) this;
    }

    /**
     * Adds one element to {@link JavaFactory#getCreateMethods() createMethods} list.
     * @param element A createMethods element
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addCreateMethods(JavaCreateMethod element) {
      this.createMethods.add(Objects.requireNonNull(element, "createMethods element"));
      return (JavaFactory.Builder) this;
    }

    /**
     * Adds elements to {@link JavaFactory#getCreateMethods() createMethods} list.
     * @param elements An array of createMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addCreateMethods(JavaCreateMethod... elements) {
      for (JavaCreateMethod element : elements) {
        this.createMethods.add(Objects.requireNonNull(element, "createMethods element"));
      }
      return (JavaFactory.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link JavaFactory#getCreateMethods() createMethods} list.
     * @param elements An iterable of createMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder createMethods(Iterable<? extends JavaCreateMethod> elements) {
      this.createMethods.clear();
      return addAllCreateMethods(elements);
    }

    /**
     * Adds elements to {@link JavaFactory#getCreateMethods() createMethods} list.
     * @param elements An iterable of createMethods elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaFactory.Builder addAllCreateMethods(Iterable<? extends JavaCreateMethod> elements) {
      for (JavaCreateMethod element : elements) {
        this.createMethods.add(Objects.requireNonNull(element, "createMethods element"));
      }
      return (JavaFactory.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaFactory ImmutableJavaFactory}.
     * @return An immutable instance of JavaFactory
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaFactory build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaFactory(
          type,
          createUnmodifiableList(true, convertMethods),
          createUnmodifiableList(true, createMethods));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build JavaFactory, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
