package io.codegen.gwt.jsonoverlay.processor.model;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaCreateMethod}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaCreateMethod.Builder()}.
 */
@Generated(from = "JavaCreateMethod", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaCreateMethod
    implements JavaCreateMethod {
  private final String methodName;
  private final ClassName returnType;

  private ImmutableJavaCreateMethod(String methodName, ClassName returnType) {
    this.methodName = methodName;
    this.returnType = returnType;
  }

  /**
   * @return the name of the method
   */
  @Override
  public String getMethodName() {
    return methodName;
  }

  /**
   * @return the type of the returned instance
   */
  @Override
  public ClassName getReturnType() {
    return returnType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaCreateMethod#getMethodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaCreateMethod withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return new ImmutableJavaCreateMethod(newValue, this.returnType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaCreateMethod#getReturnType() returnType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returnType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaCreateMethod withReturnType(ClassName value) {
    if (this.returnType == value) return this;
    ClassName newValue = Objects.requireNonNull(value, "returnType");
    return new ImmutableJavaCreateMethod(this.methodName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaCreateMethod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaCreateMethod
        && equalTo((ImmutableJavaCreateMethod) another);
  }

  private boolean equalTo(ImmutableJavaCreateMethod another) {
    return methodName.equals(another.methodName)
        && returnType.equals(another.returnType);
  }

  /**
   * Computes a hash code from attributes: {@code methodName}, {@code returnType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + returnType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavaCreateMethod} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaCreateMethod{"
        + "methodName=" + methodName
        + ", returnType=" + returnType
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaCreateMethod} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaCreateMethod instance
   */
  public static ImmutableJavaCreateMethod copyOf(JavaCreateMethod instance) {
    if (instance instanceof ImmutableJavaCreateMethod) {
      return (ImmutableJavaCreateMethod) instance;
    }
    return new JavaCreateMethod.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaCreateMethod ImmutableJavaCreateMethod}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaCreateMethod", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_METHOD_NAME = 0x1L;
    private static final long INIT_BIT_RETURN_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String methodName;
    private ClassName returnType;

    /**
     * Creates a builder for {@link ImmutableJavaCreateMethod ImmutableJavaCreateMethod} instances.
     */
    public Builder() {
      if (!(this instanceof JavaCreateMethod.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaCreateMethod.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaCreateMethod} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaCreateMethod.Builder from(JavaCreateMethod instance) {
      Objects.requireNonNull(instance, "instance");
      methodName(instance.getMethodName());
      returnType(instance.getReturnType());
      return (JavaCreateMethod.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaCreateMethod#getMethodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaCreateMethod.Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return (JavaCreateMethod.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaCreateMethod#getReturnType() returnType} attribute.
     * @param returnType The value for returnType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaCreateMethod.Builder returnType(ClassName returnType) {
      this.returnType = Objects.requireNonNull(returnType, "returnType");
      initBits &= ~INIT_BIT_RETURN_TYPE;
      return (JavaCreateMethod.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaCreateMethod ImmutableJavaCreateMethod}.
     * @return An immutable instance of JavaCreateMethod
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaCreateMethod build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaCreateMethod(methodName, returnType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_RETURN_TYPE) != 0) attributes.add("returnType");
      return "Cannot build JavaCreateMethod, some of required attributes are not set " + attributes;
    }
  }
}
