package io.codegen.gwt.jsonoverlay.processor.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JavaConvertMethod}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new JavaConvertMethod.Builder()}.
 */
@Generated(from = "JavaConvertMethod", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableJavaConvertMethod
    implements JavaConvertMethod {
  private final String methodName;
  private final JavaType returnType;
  private final JavaType argumentType;

  private ImmutableJavaConvertMethod(
      String methodName,
      JavaType returnType,
      JavaType argumentType) {
    this.methodName = methodName;
    this.returnType = returnType;
    this.argumentType = argumentType;
  }

  /**
   * @return the name of the method
   */
  @Override
  public String getMethodName() {
    return methodName;
  }

  /**
   * @return the type of the returned instance
   */
  @Override
  public JavaType getReturnType() {
    return returnType;
  }

  /**
   * @return the type of the method argument
   */
  @Override
  public JavaType getArgumentType() {
    return argumentType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaConvertMethod#getMethodName() methodName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for methodName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaConvertMethod withMethodName(String value) {
    String newValue = Objects.requireNonNull(value, "methodName");
    if (this.methodName.equals(newValue)) return this;
    return new ImmutableJavaConvertMethod(newValue, this.returnType, this.argumentType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaConvertMethod#getReturnType() returnType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returnType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaConvertMethod withReturnType(JavaType value) {
    if (this.returnType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "returnType");
    return new ImmutableJavaConvertMethod(this.methodName, newValue, this.argumentType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JavaConvertMethod#getArgumentType() argumentType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for argumentType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJavaConvertMethod withArgumentType(JavaType value) {
    if (this.argumentType == value) return this;
    JavaType newValue = Objects.requireNonNull(value, "argumentType");
    return new ImmutableJavaConvertMethod(this.methodName, this.returnType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJavaConvertMethod} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJavaConvertMethod
        && equalTo((ImmutableJavaConvertMethod) another);
  }

  private boolean equalTo(ImmutableJavaConvertMethod another) {
    return methodName.equals(another.methodName)
        && returnType.equals(another.returnType)
        && argumentType.equals(another.argumentType);
  }

  /**
   * Computes a hash code from attributes: {@code methodName}, {@code returnType}, {@code argumentType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + methodName.hashCode();
    h += (h << 5) + returnType.hashCode();
    h += (h << 5) + argumentType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JavaConvertMethod} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JavaConvertMethod{"
        + "methodName=" + methodName
        + ", returnType=" + returnType
        + ", argumentType=" + argumentType
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JavaConvertMethod} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JavaConvertMethod instance
   */
  public static ImmutableJavaConvertMethod copyOf(JavaConvertMethod instance) {
    if (instance instanceof ImmutableJavaConvertMethod) {
      return (ImmutableJavaConvertMethod) instance;
    }
    return new JavaConvertMethod.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableJavaConvertMethod ImmutableJavaConvertMethod}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JavaConvertMethod", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_METHOD_NAME = 0x1L;
    private static final long INIT_BIT_RETURN_TYPE = 0x2L;
    private static final long INIT_BIT_ARGUMENT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private String methodName;
    private JavaType returnType;
    private JavaType argumentType;

    /**
     * Creates a builder for {@link ImmutableJavaConvertMethod ImmutableJavaConvertMethod} instances.
     */
    public Builder() {
      if (!(this instanceof JavaConvertMethod.Builder)) {
        throw new UnsupportedOperationException("Use: new JavaConvertMethod.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code JavaConvertMethod} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaConvertMethod.Builder from(JavaConvertMethod instance) {
      Objects.requireNonNull(instance, "instance");
      methodName(instance.getMethodName());
      returnType(instance.getReturnType());
      argumentType(instance.getArgumentType());
      return (JavaConvertMethod.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaConvertMethod#getMethodName() methodName} attribute.
     * @param methodName The value for methodName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaConvertMethod.Builder methodName(String methodName) {
      this.methodName = Objects.requireNonNull(methodName, "methodName");
      initBits &= ~INIT_BIT_METHOD_NAME;
      return (JavaConvertMethod.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaConvertMethod#getReturnType() returnType} attribute.
     * @param returnType The value for returnType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaConvertMethod.Builder returnType(JavaType returnType) {
      this.returnType = Objects.requireNonNull(returnType, "returnType");
      initBits &= ~INIT_BIT_RETURN_TYPE;
      return (JavaConvertMethod.Builder) this;
    }

    /**
     * Initializes the value for the {@link JavaConvertMethod#getArgumentType() argumentType} attribute.
     * @param argumentType The value for argumentType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final JavaConvertMethod.Builder argumentType(JavaType argumentType) {
      this.argumentType = Objects.requireNonNull(argumentType, "argumentType");
      initBits &= ~INIT_BIT_ARGUMENT_TYPE;
      return (JavaConvertMethod.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableJavaConvertMethod ImmutableJavaConvertMethod}.
     * @return An immutable instance of JavaConvertMethod
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJavaConvertMethod build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJavaConvertMethod(methodName, returnType, argumentType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METHOD_NAME) != 0) attributes.add("methodName");
      if ((initBits & INIT_BIT_RETURN_TYPE) != 0) attributes.add("returnType");
      if ((initBits & INIT_BIT_ARGUMENT_TYPE) != 0) attributes.add("argumentType");
      return "Cannot build JavaConvertMethod, some of required attributes are not set " + attributes;
    }
  }
}
