/*
 * Decompiled with CFR 0.152.
 */
package io.cloudbeat.cucumber;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import cucumber.api.Argument;
import cucumber.api.HookTestStep;
import cucumber.api.HookType;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EmbedEvent;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import gherkin.ast.Background;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.Step;
import gherkin.deps.net.iharder.Base64;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import io.cloudbeat.cucumber.CucumberRunner;
import io.cloudbeat.cucumber.FailureModel;
import io.cloudbeat.cucumber.PayloadModel;
import io.cloudbeat.cucumber.ResultModel;
import io.cloudbeat.cucumber.StatusModel;
import io.cloudbeat.cucumber.TestSourcesModel;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;

public final class Plugin
implements EventListener {
    private String currentFeatureFile;
    private List<Map<String, Object>> featureMaps = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> currentElementsList;
    private Map<String, Object> currentElementMap;
    private Map<String, Object> currentTestCaseMap;
    private List<Map<String, Object>> currentStepsList;
    private Map<String, Object> currentStepOrHookMap;
    private Map<String, Object> currentBeforeStepHookList = new HashMap<String, Object>();
    private final TestSourcesModel testSources = new TestSourcesModel();
    private PayloadModel payload;
    private ResultModel result;
    private String testMonitorStatusUrl;
    private String testMonitorToken;
    private boolean isInitialized = false;
    private int currentCaseIndex = 1;
    private static final String TEST_RESULTS_FILENAME = ".CB_TEST_RESULTS";
    private static final String ERR_CUCUMBER_ERROR = "CUCUMBER_ERROR";
    private EventHandler<TestSourceRead> testSourceReadHandler = event -> this.handleTestSourceRead((TestSourceRead)event);
    private EventHandler<TestCaseStarted> caseStartedHandler = event -> this.handleTestCaseStarted((TestCaseStarted)event);
    private EventHandler<TestCaseFinished> caseFinishedHandler = event -> this.handleTestCaseFinished((TestCaseFinished)event);
    private EventHandler<TestStepStarted> stepStartedHandler = event -> this.handleTestStepStarted((TestStepStarted)event);
    private EventHandler<TestStepFinished> stepFinishedHandler = event -> this.handleTestStepFinished((TestStepFinished)event);
    private EventHandler<TestRunFinished> runFinishedHandler = event -> this.finishReport();
    private EventHandler<EmbedEvent> embedEventhandler = event -> this.handleEmbed((EmbedEvent)event);

    public Plugin(String arg) {
        String payloadpath = System.getProperty("payloadpath");
        String testmonitorurl = System.getProperty("testmonitorurl");
        this.testMonitorToken = System.getProperty("testmonitortoken");
        if (payloadpath != null && testmonitorurl != null && this.testMonitorToken != null) {
            this.testMonitorStatusUrl = testmonitorurl + "/status";
            try {
                this.payload = PayloadModel.Load(payloadpath);
                this.result = new ResultModel();
                this.result.runId = this.payload.runId;
                this.result.instanceId = this.payload.instanceId;
                this.result.capabilities = this.payload.capabilities;
                this.result.metadata = this.payload.metadata;
                this.result.environmentVariables = this.payload.environmentVariables;
                this.result.startTime = new Date();
                if (this.result.capabilities.containsKey("browserName")) {
                    String browserName = this.result.capabilities.get("browserName");
                    int browserNameIdx = browserName.indexOf(46);
                    if (browserNameIdx > 0) {
                        browserName = browserName.substring(browserNameIdx + 1);
                    }
                    System.setProperty("browserName", browserName);
                } else {
                    this.logError("Plugin will be disabled. browserName is not specified in capabilities.");
                }
                this.isInitialized = true;
            }
            catch (Exception e) {
                this.logError("Plugin will be disabled. Unable to read/deserialize payload file.", e);
            }
        } else {
            this.logInfo("Plugin will be disabled. One of payloadpath, testmonitorurl, or testmonitortoken parameters is missing.");
        }
    }

    public void setEventPublisher(EventPublisher publisher) {
        if (!this.isInitialized) {
            return;
        }
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestCaseFinished.class, this.caseFinishedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(EmbedEvent.class, this.embedEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            this.currentFeatureFile = event.testCase.getUri();
            Map<String, Object> currentFeatureMap = this.createFeatureMap(event.testCase);
            this.featureMaps.add(currentFeatureMap);
            this.currentElementsList = (List)currentFeatureMap.get("elements");
        }
        this.currentTestCaseMap = this.createTestCase(event.testCase);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.currentElementMap = this.createBackground(event.testCase);
            this.currentElementsList.add(this.currentElementMap);
        } else {
            this.currentElementMap = this.currentTestCaseMap;
        }
        this.currentElementsList.add(this.currentTestCaseMap);
        this.currentStepsList = (List)this.currentElementMap.get("steps");
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        boolean isPassed = true;
        for (Map<String, Object> step : this.currentStepsList) {
            Map result = (Map)step.get("result");
            if (result == null || result.get("status").equals("passed")) continue;
            isPassed = false;
        }
        StatusModel status = new StatusModel();
        status.status = StatusModel.Statuses.Running.getValue();
        status.instanceId = this.payload.instanceId;
        status.runId = this.payload.runId;
        status.caze = new StatusModel.CaseStatus();
        status.progress = (float)this.currentCaseIndex / (float)this.payload.cases.size();
        String cucumberId = this.getCucumberScenarioId(event.testCase.getScenarioDesignation());
        PayloadModel.Case caseDefinition = this.payload.cases.get(cucumberId);
        if (caseDefinition == null) {
            this.logError("Cannot find matching case in the payload: " + cucumberId + ". Test case status won't be reported.");
            return;
        }
        status.caze.id = caseDefinition.id;
        status.caze.order = this.currentCaseIndex;
        status.caze.progress = 1.0f;
        status.caze.name = event.testCase.getName();
        status.caze.iterationsFailed = isPassed ? 0 : 1;
        status.caze.iterationsPassed = isPassed ? 1 : 0;
        ++this.currentCaseIndex;
        if (this.report(this.testMonitorStatusUrl, status)) {
            this.logInfo("Status report for '" + cucumberId + "' has been sent");
        }
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep) {
            PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
            if (this.isFirstStepAfterBackground(testStep)) {
                this.currentElementMap = this.currentTestCaseMap;
                this.currentStepsList = (List)this.currentElementMap.get("steps");
            }
            this.currentStepOrHookMap = this.createTestStep(testStep);
            if (this.currentBeforeStepHookList.containsKey(HookType.Before.toString())) {
                this.currentStepOrHookMap.put(HookType.Before.toString(), this.currentBeforeStepHookList.get(HookType.Before.toString()));
                this.currentBeforeStepHookList.clear();
            }
            this.currentStepsList.add(this.currentStepOrHookMap);
        } else if (event.testStep instanceof HookTestStep) {
            HookTestStep hookTestStep = (HookTestStep)event.testStep;
            this.currentStepOrHookMap = this.createHookStep(hookTestStep);
            this.addHookStepToTestCaseMap(this.currentStepOrHookMap, hookTestStep.getHookType());
        } else {
            throw new IllegalStateException();
        }
    }

    private void handleEmbed(EmbedEvent event) {
        this.addEmbeddingToHookMap(event.data, event.mimeType);
    }

    private void handleTestStepFinished(TestStepFinished event) {
        this.currentStepOrHookMap.put("match", this.createMatchMap(event.testStep, event.result));
        this.currentStepOrHookMap.put("result", this.createResultMap(event.result));
    }

    private void finishReport() {
        String resultJson;
        this.result.endTime = new Date();
        this.result.duration = (double)(this.result.endTime.getTime() - this.result.startTime.getTime()) / 1000.0;
        this.result.retries = 0;
        this.result.iterations = new ArrayList<ResultModel.SuiteIteration>();
        ResultModel.SuiteIteration iter = new ResultModel.SuiteIteration();
        this.result.iterations.add(iter);
        iter.iterationNum = 1;
        iter.cases = new ArrayList<ResultModel.Case>();
        block6: for (Map<String, Object> map : this.featureMaps) {
            List scenarios = (List)map.get("elements");
            for (Map scenario : scenarios) {
                ResultModel.Case caze = new ResultModel.Case();
                iter.cases.add(caze);
                String cucumberId = (String)scenario.get("cucumberId");
                PayloadModel.Case caseDefinition = this.payload.cases.get(cucumberId);
                if (caseDefinition == null) {
                    this.logError("Cannot find matching case in the payload: " + cucumberId + ". Test case result for this case won't be included in the report.");
                    continue block6;
                }
                caze.id = caseDefinition.id;
                caze.name = (String)scenario.get("name");
                caze.iterations = new ArrayList<ResultModel.CaseIteration>();
                ResultModel.CaseIteration caseIteration = new ResultModel.CaseIteration();
                caze.iterations.add(caseIteration);
                caseIteration.iterationNum = 1;
                caseIteration.hasWarnings = false;
                caseIteration.context = null;
                caseIteration.failure = null;
                caseIteration.har = null;
                caseIteration.steps = new ArrayList<ResultModel.Step>();
                boolean isSuccess = true;
                short order = 0;
                for (Map cucStep : (List)scenario.get("steps")) {
                    Map cucStepResult = (Map)cucStep.get("result");
                    FailureModel failure = null;
                    boolean stepStatus = cucStepResult.get("status").equals("passed");
                    if (!stepStatus) {
                        isSuccess = false;
                        failure = new FailureModel();
                        failure.type = ERR_CUCUMBER_ERROR;
                        if (cucStepResult.containsKey("error_message")) {
                            failure.data = (String)cucStepResult.get("error_message");
                        } else {
                            failure.message = "See console log for more details";
                        }
                    }
                    ResultModel.Step step = new ResultModel.Step();
                    step.name = (String)cucStep.get("name");
                    step.order = order;
                    step.isSuccess = stepStatus;
                    step.transactionName = step.name;
                    if (!isSuccess) {
                        if (this.currentStepOrHookMap.containsKey("embeddings")) {
                            for (Map embedding : (List)this.currentStepOrHookMap.get("embeddings")) {
                                if (!embedding.containsKey("mime_type") || !embedding.containsKey("data") || !"image/png".equals(embedding.get("mime_type"))) continue;
                                step.screenshot = (String)embedding.get("data");
                                break;
                            }
                        } else {
                            step.screenshot = this.takeWebDriverScreenshot();
                        }
                    }
                    if (cucStepResult.containsKey("duration")) {
                        step.duration = (double)((Long)cucStepResult.get("duration")).longValue() / 1000000.0;
                    }
                    step.iterationNum = 1;
                    try {
                        step.failure = failure == null ? null : new ObjectMapper().writeValueAsString((Object)failure);
                    }
                    catch (JsonProcessingException e) {
                        this.logError("Cannot serialize failure details for " + cucumberId, (Exception)((Object)e));
                    }
                    caseIteration.steps.add(step);
                    order = (short)(order + 1);
                }
                caseIteration.isSuccess = isSuccess;
                caze.isSuccess = isSuccess;
            }
        }
        boolean isSuccess = true;
        for (ResultModel.Case caze : iter.cases) {
            for (ResultModel.CaseIteration caseIteration : caze.iterations) {
                if (caseIteration.isSuccess) continue;
                isSuccess = false;
            }
        }
        iter.isSuccess = isSuccess;
        this.result.isSuccess = isSuccess;
        this.result.iterationsTotal = 1;
        this.result.iterationsPassed = isSuccess ? 0 : 1;
        this.result.iterationsFailed = isSuccess ? 0 : 1;
        this.result.iterationsWarning = 0;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            resultJson = objectMapper.writeValueAsString((Object)this.result);
        }
        catch (JsonProcessingException e) {
            this.logError("Failed to serialize results.", (Exception)((Object)e));
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(TEST_RESULTS_FILENAME, "UTF-8");
            writer.write(resultJson);
            writer.close();
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            this.logError("Failed to create .CB_TEST_RESULTS", e);
        }
    }

    private Map<String, Object> createFeatureMap(TestCase testCase) {
        HashMap<String, Object> featureMap = new HashMap<String, Object>();
        featureMap.put("uri", testCase.getUri());
        featureMap.put("elements", new ArrayList());
        Feature feature = this.testSources.getFeature(testCase.getUri());
        if (feature != null) {
            featureMap.put("keyword", feature.getKeyword());
            featureMap.put("name", feature.getName());
            featureMap.put("description", feature.getDescription() != null ? feature.getDescription() : "");
            featureMap.put("line", feature.getLocation().getLine());
            featureMap.put("id", TestSourcesModel.convertToId(feature.getName()));
            featureMap.put("tags", feature.getTags());
        }
        return featureMap;
    }

    private Map<String, Object> createTestCase(TestCase testCase) {
        HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
        testCaseMap.put("name", testCase.getName());
        testCaseMap.put("line", testCase.getLine());
        testCaseMap.put("type", "scenario");
        testCaseMap.put("cucumberId", this.getCucumberScenarioId(testCase.getScenarioDesignation()));
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            testCaseMap.put("id", TestSourcesModel.calculateId(astNode));
            ScenarioDefinition scenarioDefinition = TestSourcesModel.getScenarioDefinition(astNode);
            testCaseMap.put("keyword", scenarioDefinition.getKeyword());
            testCaseMap.put("description", scenarioDefinition.getDescription() != null ? scenarioDefinition.getDescription() : "");
        }
        testCaseMap.put("steps", new ArrayList());
        if (!testCase.getTags().isEmpty()) {
            ArrayList tagList = new ArrayList();
            for (PickleTag tag : testCase.getTags()) {
                HashMap<String, String> tagMap = new HashMap<String, String>();
                tagMap.put("name", tag.getName());
                tagList.add(tagMap);
            }
            testCaseMap.put("tags", tagList);
        }
        return testCaseMap;
    }

    private Map<String, Object> createBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            HashMap<String, Object> testCaseMap = new HashMap<String, Object>();
            testCaseMap.put("name", background.getName());
            testCaseMap.put("line", background.getLocation().getLine());
            testCaseMap.put("type", "background");
            testCaseMap.put("keyword", background.getKeyword());
            testCaseMap.put("description", background.getDescription() != null ? background.getDescription() : "");
            testCaseMap.put("steps", new ArrayList());
            return testCaseMap;
        }
        return null;
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        return astNode != null && this.currentElementMap != this.currentTestCaseMap && !TestSourcesModel.isBackgroundStep(astNode);
    }

    private Map<String, Object> createTestStep(PickleStepTestStep testStep) {
        HashMap<String, Object> stepMap = new HashMap<String, Object>();
        stepMap.put("name", testStep.getStepText());
        stepMap.put("line", testStep.getStepLine());
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (!testStep.getStepArgument().isEmpty()) {
            gherkin.pickles.Argument argument = (gherkin.pickles.Argument)testStep.getStepArgument().get(0);
            if (argument instanceof PickleString) {
                stepMap.put("doc_string", this.createDocStringMap(argument));
            } else if (argument instanceof PickleTable) {
                stepMap.put("rows", this.createDataTableList(argument));
            }
        }
        if (astNode != null) {
            Step step = (Step)astNode.node;
            stepMap.put("keyword", step.getKeyword());
        }
        return stepMap;
    }

    private Map<String, Object> createDocStringMap(gherkin.pickles.Argument argument) {
        HashMap<String, Object> docStringMap = new HashMap<String, Object>();
        PickleString docString = (PickleString)argument;
        docStringMap.put("value", docString.getContent());
        docStringMap.put("line", docString.getLocation().getLine());
        docStringMap.put("content_type", docString.getContentType());
        return docStringMap;
    }

    private List<Map<String, Object>> createDataTableList(gherkin.pickles.Argument argument) {
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>();
        for (PickleRow row : ((PickleTable)argument).getRows()) {
            HashMap<String, List<String>> rowMap = new HashMap<String, List<String>>();
            rowMap.put("cells", this.createCellList(row));
            rowList.add(rowMap);
        }
        return rowList;
    }

    private List<String> createCellList(PickleRow row) {
        ArrayList<String> cells = new ArrayList<String>();
        for (PickleCell cell : row.getCells()) {
            cells.add(cell.getValue());
        }
        return cells;
    }

    private Map<String, Object> createHookStep(HookTestStep hookTestStep) {
        return new HashMap<String, Object>();
    }

    private void addHookStepToTestCaseMap(Map<String, Object> currentStepOrHookMap, HookType hookType) {
        Map<String, Object> mapToAddTo;
        String hookName = hookType.toString().contains("after") ? "after" : "before";
        switch (hookType) {
            case Before: {
                mapToAddTo = this.currentTestCaseMap;
                break;
            }
            case After: {
                mapToAddTo = this.currentTestCaseMap;
                break;
            }
            case BeforeStep: {
                mapToAddTo = this.currentBeforeStepHookList;
                break;
            }
            case AfterStep: {
                mapToAddTo = this.currentStepsList.get(this.currentStepsList.size() - 1);
                break;
            }
            default: {
                mapToAddTo = this.currentTestCaseMap;
            }
        }
        if (!mapToAddTo.containsKey(hookName)) {
            mapToAddTo.put(hookName, new ArrayList());
        }
        ((List)mapToAddTo.get(hookName)).add(currentStepOrHookMap);
    }

    private void addEmbeddingToHookMap(byte[] data, String mimeType) {
        if (!this.currentStepOrHookMap.containsKey("embeddings")) {
            this.currentStepOrHookMap.put("embeddings", new ArrayList());
        }
        Map<String, Object> embedMap = this.createEmbeddingMap(data, mimeType);
        ((List)this.currentStepOrHookMap.get("embeddings")).add(embedMap);
    }

    private Map<String, Object> createEmbeddingMap(byte[] data, String mimeType) {
        HashMap<String, Object> embedMap = new HashMap<String, Object>();
        embedMap.put("mime_type", mimeType);
        embedMap.put("data", Base64.encodeBytes((byte[])data));
        return embedMap;
    }

    private Map<String, Object> createMatchMap(TestStep step, Result result) {
        PickleStepTestStep testStep;
        HashMap<String, Object> matchMap = new HashMap<String, Object>();
        if (step instanceof PickleStepTestStep && !(testStep = (PickleStepTestStep)step).getDefinitionArgument().isEmpty()) {
            ArrayList argumentList = new ArrayList();
            for (Argument argument : testStep.getDefinitionArgument()) {
                HashMap<String, Object> argumentMap = new HashMap<String, Object>();
                if (argument.getValue() != null) {
                    argumentMap.put("val", argument.getValue());
                    argumentMap.put("offset", argument.getStart());
                }
                argumentList.add(argumentMap);
            }
            matchMap.put("arguments", argumentList);
        }
        if (!result.is(Result.Type.UNDEFINED)) {
            matchMap.put("location", step.getCodeLocation());
        }
        return matchMap;
    }

    private Map<String, Object> createResultMap(Result result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("status", result.getStatus().lowerCaseName());
        if (result.getErrorMessage() != null) {
            resultMap.put("error_message", result.getErrorMessage());
        }
        if (result.getDuration() != null && result.getDuration() != 0L) {
            resultMap.put("duration", result.getDuration());
        }
        return resultMap;
    }

    private String getCucumberScenarioId(String caseDesignation) {
        String[] tokens = caseDesignation.split("/");
        return tokens[tokens.length - 1];
    }

    private String takeWebDriverScreenshot() {
        WebDriver driver = CucumberRunner.getWebDriver();
        if (driver == null || !(driver instanceof TakesScreenshot)) {
            return null;
        }
        return (String)((TakesScreenshot)driver).getScreenshotAs(OutputType.BASE64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean report(String endpointUrl, Object data) {
        block32: {
            HttpURLConnection http = null;
            try {
                ObjectMapper mapper = new ObjectMapper();
                String json = mapper.writeValueAsString(data);
                byte[] out = json.getBytes(StandardCharsets.UTF_8);
                int length = out.length;
                URL url = new URL(endpointUrl);
                URLConnection con = url.openConnection();
                http = (HttpURLConnection)con;
                http.setRequestMethod("POST");
                http.setRequestProperty("Authorization", "Bearer " + this.testMonitorToken);
                http.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                http.setRequestProperty("Connection", "Close");
                http.setDoOutput(true);
                http.setFixedLengthStreamingMode(length);
                http.connect();
                try (OutputStream os = http.getOutputStream();){
                    os.write(out);
                    os.flush();
                }
                int responseCode = http.getResponseCode();
                if (responseCode >= 200 && responseCode <= 299) break block32;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));){
                    String inputLine;
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    this.logError("Unable to report to " + endpointUrl + " : " + responseCode + " - " + response.toString());
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                this.logError("Unable to report to " + endpointUrl, e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (http != null) {
                    http.disconnect();
                }
            }
        }
        return true;
    }

    private void logError(String message) {
        System.err.println("[CloudBeat] " + message);
    }

    private void logError(String message, Exception e) {
        System.err.println("[CloudBeat] " + message);
        e.printStackTrace();
    }

    private void logInfo(String message) {
        System.out.println("[CloudBeat] " + message);
    }
}

