/*
 * Decompiled with CFR 0.152.
 */
package io.cloudbeat.cucumber;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class PayloadModel {
    public String runId;
    public String instanceId;
    public Map<String, String> metadata;
    public Map<String, String> capabilities;
    public String environmentVariables;
    public Map<String, Case> cases = new HashMap<String, Case>();

    public static PayloadModel Load(String path) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
        String json = new String(encoded, StandardCharsets.UTF_8);
        PayloadModel payload = new PayloadModel();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readValue(json, JsonNode.class);
        TypeReference<Map<String, Object>> mapTypeRef = new TypeReference<Map<String, Object>>(){};
        payload.runId = rootNode.get("RunId").textValue();
        payload.instanceId = rootNode.get("InstanceId").textValue();
        payload.capabilities = (Map)mapper.readValue(rootNode.get("Capabilities").toString(), (TypeReference)mapTypeRef);
        payload.metadata = (Map)mapper.readValue(rootNode.get("Metadata").toString(), (TypeReference)mapTypeRef);
        payload.environmentVariables = rootNode.get("EnvironmentVariables").textValue();
        for (JsonNode caseNode : rootNode.get("Cases")) {
            Case caze = new Case();
            caze.id = caseNode.get("Id").asLong();
            JsonNode details = caseNode.get("Details");
            caze.cucumberId = details.get("cucumberId").textValue();
            caze.order = caseNode.get("Order").asInt();
            payload.cases.put(caze.cucumberId, caze);
        }
        return payload;
    }

    public static class Case {
        public long id;
        public String cucumberId;
        public int order;
    }
}

