/*
 * Decompiled with CFR 0.152.
 */
package io.clarify.api;

import io.clarify.api.Bundle;
import io.clarify.api.BundleList;
import io.clarify.api.BundleMetadata;
import io.clarify.api.BundleSearchResults;
import io.clarify.api.BundleTrack;
import io.clarify.api.BundleTrackList;
import io.clarify.api.ClarifyResponse;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import us.monoid.json.JSONException;
import us.monoid.json.JSONObject;
import us.monoid.web.AbstractContent;
import us.monoid.web.Content;
import us.monoid.web.FormData;
import us.monoid.web.JSONResource;
import us.monoid.web.Resty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClarifyClient
extends Resty {
    public static String CLARIFY_BASE_URI = "https://api.clarify.io";
    public static String DEFAULT_VERSION = "v1";
    public static String SDK_VERSION = "1.0.0";
    private String appKey;
    private Resty resty;

    public ClarifyClient(String appKey) {
        super(new Resty.Option[0]);
        this.appKey = appKey;
        this.withHeader("Authorization", "Bearer " + appKey);
        this.userAgent = "clarify-java/" + SDK_VERSION + "/" + System.getProperty("java.version");
    }

    public Bundle createBundle(String name, URI mediaURI) throws IOException {
        return this.createBundle(name, mediaURI, null);
    }

    public Bundle createBundle(String name, URI mediaURI, Map<String, String> fields) throws IOException {
        if (name == null) {
            throw new RuntimeException("name cannot be null");
        }
        if (fields == null) {
            fields = new HashMap<String, String>();
        }
        fields.put("name", name);
        if (mediaURI != null) {
            fields.put("media_url", mediaURI.toString());
        }
        String params = this.urlEncodeMap(fields);
        Content content = new Content("application/x-www-form-urlencoded", params.getBytes());
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles"), (AbstractContent)content);
        try {
            String bundleId = (String)jsonResource.get("id");
            return this.findBundle(bundleId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BundleList listBundles() throws IOException {
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles"));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleList list = new BundleList(this, resp);
        return list;
    }

    public BundleSearchResults searchBundles(String query) throws IOException {
        return this.searchBundles(query, null);
    }

    public BundleSearchResults searchBundles(String query, Map<String, String> params) throws IOException {
        if (query == null) {
            throw new RuntimeException("query cannot be null");
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("query", ClarifyClient.enc((String)query));
        String urlParams = this.urlEncodeMap(params);
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/search?" + urlParams));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleSearchResults results = new BundleSearchResults(this, resp);
        return results;
    }

    public Bundle findBundleByHref(String href) throws IOException {
        if (href == null) {
            throw new RuntimeException("href cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromHref(href));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        Bundle bundle = new Bundle(this, resp);
        return bundle;
    }

    public Bundle findBundle(String bundleId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        Bundle bundle = new Bundle(this, resp);
        return bundle;
    }

    public boolean updateBundle(String bundleId, Map<String, String> fields) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        if (fields == null) {
            throw new RuntimeException("fields cannot be null");
        }
        if (fields.size() == 0) {
            throw new RuntimeException("fields cannot be empty");
        }
        String params = this.urlEncodeMap(fields);
        Content content = new Content("application/x-www-form-urlencoded", params.getBytes());
        String url = this.buildPathFromResourcePath("/bundles/" + bundleId);
        this.json(url, ClarifyClient.put((Content)content));
        return true;
    }

    public boolean deleteBundle(String bundleId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        this.json(this.buildPathFromResourcePath("/bundles/" + ClarifyClient.enc((String)bundleId)), ClarifyClient.delete());
        return true;
    }

    public BundleTrackList listTracksForBundle(String bundleId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/tracks"));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleTrackList trackList = new BundleTrackList(this, resp);
        return trackList;
    }

    public BundleTrack addTrackToBundle(String bundleId, URI trackUri) throws IOException {
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/tracks"), (AbstractContent)ClarifyClient.form((FormData[])new FormData[]{ClarifyClient.data((String)"media_url", (String)trackUri.toString())}));
        try {
            String trackHref = (String)jsonResource.get("_links.self.href");
            return this.findTrackByHref(trackHref);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BundleTrack findTrackForBundle(String bundleId, String trackId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        if (trackId == null) {
            throw new RuntimeException("trackId cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/tracks/" + trackId));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleTrack track = new BundleTrack(this, resp);
        return track;
    }

    public BundleTrack findTrackByHref(String href) throws IOException {
        if (href == null) {
            throw new RuntimeException("href cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromHref(href));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleTrack track = new BundleTrack(this, resp);
        return track;
    }

    public boolean deleteTrack(String bundleId, String trackId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/tracks/" + trackId), ClarifyClient.delete());
        return true;
    }

    public BundleMetadata findMetadata(String bundleId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/metadata"));
        ClarifyResponse resp = new ClarifyResponse(jsonResource);
        BundleMetadata metadata = new BundleMetadata(this, resp);
        return metadata;
    }

    public BundleMetadata updateMetadata(String bundleId, String json) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        if (json == null) {
            json = "{}";
        }
        JSONObject payload = null;
        try {
            payload = new JSONObject().put("data", (Object)json);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        JSONResource jsonResource = this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/metadata"), ClarifyClient.put((Content)ClarifyClient.content((JSONObject)payload)));
        return this.findMetadata(bundleId);
    }

    public boolean resetMetadata(String bundleId) throws IOException {
        if (bundleId == null) {
            throw new RuntimeException("bundleId cannot be null");
        }
        this.json(this.buildPathFromResourcePath("/bundles/" + bundleId + "/metadata"), ClarifyClient.delete());
        return true;
    }

    public String buildPathFromHref(String href) {
        return this.baseUri() + href;
    }

    public String buildPathFromResourcePath(String resourcePath) {
        return this.baseUri() + "/" + this.version() + resourcePath;
    }

    public String urlEncodeMap(Map<String, String> fields) {
        StringBuffer params = new StringBuffer();
        for (String key : fields.keySet()) {
            String value = fields.get(key);
            if (params.length() > 0) {
                params.append("&");
            }
            params.append(key + "=" + Resty.enc((String)value));
        }
        return params.toString();
    }

    protected String baseUri() {
        return CLARIFY_BASE_URI;
    }

    protected String version() {
        return DEFAULT_VERSION;
    }
}

