/*
 * Decompiled with CFR 0.152.
 */
package io.clarify.api;

import io.clarify.api.BundleMetadata;
import io.clarify.api.BundleTrack;
import io.clarify.api.BundleTrackList;
import io.clarify.api.ClarifyClient;
import io.clarify.api.ClarifyModel;
import io.clarify.api.ClarifyResponse;
import java.io.IOException;
import java.net.URI;

public class Bundle
extends ClarifyModel {
    public Bundle(ClarifyClient client, ClarifyResponse response) {
        super(client, response);
    }

    public String getId() {
        try {
            return (String)this.response.getJSONResource().get("id");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete() throws IOException {
        return this.client.deleteBundle(this.getId());
    }

    public BundleTrack addTrack(URI uri) throws IOException {
        return this.client.addTrackToBundle(this.getId(), uri);
    }

    public BundleTrackList listTracks() throws IOException {
        return this.client.listTracksForBundle(this.getId());
    }

    public BundleTrack findTrack(String trackId) throws IOException {
        return this.client.findTrackForBundle(this.getId(), trackId);
    }

    public boolean deleteTrack(String trackId) throws IOException {
        return this.client.deleteTrack(this.getId(), trackId);
    }

    public BundleMetadata getMetadata() throws IOException {
        return this.client.findMetadata(this.getId());
    }
}

