package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class Sticker(
    @SerialName("file_id") public val fileId: String,
    @SerialName("file_unique_id") public val fileUniqueId: String,
    public val width: Int,
    public val height: Int,
    @SerialName("is_animated") public val isAnimated: Boolean,
    @SerialName("is_video") public val isVideo: Boolean,
    public val thumb: PhotoSize? = null,
    public val emoji: String? = null,
    @SerialName("set_name") public val setName: String? = null,
    @SerialName("mask_position") public val maskPosition: MaskPosition? = null,
    @SerialName("file_size") public val fileSize: Int? = null
)