package io.ciogram.types

public inline fun ReplyKeyboardMarkup(block: ReplyKeyboardMarkupBuilder.() -> Unit): ReplyKeyboardMarkup {
    return ReplyKeyboardMarkupBuilder().apply(block).build()
}

public class ReplyKeyboardMarkupBuilder @PublishedApi internal constructor() {
    @PublishedApi
    internal val rows: MutableList<List<KeyboardButton>> = mutableListOf()

    public var resizeKeyboard: Boolean? = null
    public var oneTimeKeyboard: Boolean? = null
    public var inputFieldPlaceholder: String? = null
    public var selective: Boolean? = null

    public inline fun row(block: ReplyKeyboardRowBuilder.() -> Unit) {
        rows.add(ReplyKeyboardRowBuilder().apply(block).build())
    }

    public fun build(): ReplyKeyboardMarkup {
        return ReplyKeyboardMarkup(rows.toList(), resizeKeyboard, oneTimeKeyboard, inputFieldPlaceholder, selective)
    }
}

public class ReplyKeyboardRowBuilder @PublishedApi internal constructor() {
    @PublishedApi
    internal val buttons: MutableList<KeyboardButton> = mutableListOf()

    public inline fun button(text: String, block: ReplyKeyboardButtonBuilder.() -> Unit) {
        buttons.add(ReplyKeyboardButtonBuilder(text).apply(block).build())
    }

    public fun button(text: String) {
        buttons.add(ReplyKeyboardButtonBuilder(text).build())
    }

    public fun build(): List<KeyboardButton> {
        return buttons.toList()
    }
}

public class ReplyKeyboardButtonBuilder @PublishedApi internal constructor(public var text: String) {
    public var requestContact: Boolean? = null
    public var requestLocation: Boolean? = null
    public var requestPoll: KeyboardButtonPollType? = null

    public fun build(): KeyboardButton {
        return KeyboardButton(text, requestContact, requestLocation, requestPoll)
    }
}