package io.ciogram.types

import kotlinx.serialization.*
import kotlinx.serialization.json.JsonClassDiscriminator

@Serializable
@JsonClassDiscriminator("source")
@OptIn(ExperimentalSerializationApi::class)
public sealed class PassportElementError {
    public abstract val source: String
}

@Serializable
@SerialName("data")
public data class PassportElementErrorDataField(
    public val type: String,
    @SerialName("field_name") public val fieldName: String,
    @SerialName("data_hash") public val dataHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "data"
}

@Serializable
@SerialName("front_side")
public data class PassportElementErrorFrontSide(
    public val type: String,
    @SerialName("file_hash") public val fileHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "front_side"
}

@Serializable
@SerialName("reverse_side")
public data class PassportElementErrorReverseSide(
    public val type: String,
    @SerialName("file_hash") public val fileHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "reverse_side"
}

@Serializable
@SerialName("selfie")
public data class PassportElementErrorSelfie(
    public val type: String,
    @SerialName("file_hash") public val fileHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "selfie"
}

@Serializable
@SerialName("file")
public data class PassportElementErrorFile(
    public val type: String,
    @SerialName("file_hash") public val fileHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "file"
}

@Serializable
@SerialName("files")
public data class PassportElementErrorFiles(
    public val type: String,
    @SerialName("file_hashes") public val fileHashes: List<String>,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "files"
}

@Serializable
@SerialName("translation_file")
public data class PassportElementErrorTranslationFile(
    public val type: String,
    @SerialName("file_hash") public val fileHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "translation_file"
}

@Serializable
@SerialName("translation_files")
public data class PassportElementErrorTranslationFiles(
    public val type: String,
    @SerialName("file_hashes") public val fileHashes: List<String>,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "translation_files"
}

@Serializable
@SerialName("unspecified")
public data class PassportElementErrorUnspecified(
    public val type: String,
    @SerialName("element_hash") public val elementHash: String,
    public val message: String
) : PassportElementError() {
    @Transient
    public override val source: String = "unspecified"
}