package io.ciogram.types

public object ChatType {
    public const val PRIVATE: String = "private"
    public const val GROUP: String = "group"
    public const val SUPERGROUP: String = "supergroup"
    public const val CHANNEL: String = "channel"
}

public object UpdateType {
    public const val MESSAGE: String = "message"
    public const val EDITED_MESSAGE: String = "edited_message"
    public const val CHANNEL_POST: String = "channel_post"
    public const val EDITED_CHANNEL_POST: String = "edited_channel_post"
    public const val INLINE_QUERY: String = "inline_query"
    public const val CHOSEN_INLINE_RESULT: String = "chosen_inline_result"
    public const val CALLBACK_QUERY: String = "callback_query"
    public const val SHIPPING_QUERY: String = "shipping_query"
    public const val PRE_CHECKOUT_QUERY: String = "pre_checkout_query"
    public const val POLL: String = "poll"
    public const val POLL_ANSWER: String = "poll_answer"
    public const val MY_CHAT_MEMBER: String = "my_chat_member"
    public const val CHAT_MEMBER: String = "chat_member"
    public const val CHAT_JOIN_REQUEST: String = "chat_join_request"
}

public object ParseMode {
    public const val HTML: String = "HTML"
    public const val MARKDOWN: String = "Markdown"
    public const val MARKDOWN_V2: String = "MarkdownV2"
}

public object ChatAction {
    public const val TYPING: String = "typing"
    public const val UPLOAD_PHOTO: String = "upload_photo"
    public const val RECORD_VIDEO: String = "record_video"
    public const val UPLOAD_VIDEO: String = "upload_video"
    public const val RECORD_VOICE: String = "record_voice"
    public const val UPLOAD_VOICE: String = "upload_voice"
    public const val UPLOAD_DOCUMENT: String = "upload_document"
    public const val CHOOSE_STICKER: String = "choose_sticker"
    public const val FIND_LOCATION: String = "find_location"
    public const val RECORD_VIDEO_NOTE: String = "record_video_note"
    public const val UPLOAD_VIDEO_NOTE: String = "upload_video_note"
}

public object MessageEntityType {
    public const val MENTION: String = "mention"
    public const val HASHTAG: String = "hashtag"
    public const val CASHTAG: String = "cashtag"
    public const val BOT_COMMAND: String = "bot_command"
    public const val URL: String = "url"
    public const val EMAIL: String = "email"
    public const val PHONE_NUMBER: String = "phone_number"
    public const val BOLD: String = "bold"
    public const val ITALIC: String = "italic"
    public const val UNDERLINE: String = "underline"
    public const val STRIKETHROUGH: String = "strikethrough"
    public const val SPOILER: String = "spoiler"
    public const val CODE: String = "code"
    public const val PRE: String = "pre"
    public const val TEXT_LINK: String = "text_link"
    public const val TEXT_MENTION: String = "text_mention"
}