package io.ciogram.types

import kotlinx.serialization.*
import kotlinx.serialization.json.JsonClassDiscriminator

@Serializable
@JsonClassDiscriminator("type")
@OptIn(ExperimentalSerializationApi::class)
public sealed class BotCommandScope {
    public abstract val type: String
}

@Serializable
@SerialName("default")
public class BotCommandScopeDefault : BotCommandScope() {
    @Transient
    public override val type: String = "default"
}

@Serializable
@SerialName("all_private_chats")
public class BotCommandScopeAllPrivateChats : BotCommandScope() {
    @Transient
    public override val type: String = "all_private_chats"
}

@Serializable
@SerialName("all_group_chats")
public class BotCommandScopeAllGroupChats : BotCommandScope() {
    @Transient
    public override val type: String = "all_group_chats"
}

@Serializable
@SerialName("all_chat_administrators")
public class BotCommandScopeAllChatAdministrators : BotCommandScope() {
    @Transient
    public override val type: String = "all_chat_administrators"
}

@Serializable
@SerialName("chat")
public data class BotCommandScopeChat(
    @SerialName("chat_id") public val chatId: String
) : BotCommandScope() {
    @Transient
    public override val type: String = "chat"
}

@Serializable
@SerialName("chat_administrators")
public data class BotCommandScopeChatAdministrators(
    @SerialName("chat_id") public val chatId: String
) : BotCommandScope() {
    @Transient
    public override val type: String = "chat_administrators"
}

@Serializable
@SerialName("chat_member")
public data class BotCommandScopeChatMember(
    @SerialName("chat_id") public val chatId: String,
    @SerialName("user_id") public val userId: Long
) : BotCommandScope() {
    @Transient
    public override val type: String = "chat_member"
}