package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class Update(
    @SerialName("update_id") public val updateId: Int,
    public val message: Message? = null,
    @SerialName("edited_message") public val editedMessage: Message? = null,
    @SerialName("channel_post") public val channelPost: Message? = null,
    @SerialName("edited_channel_post") public val editedChannelPost: Message? = null,
    @SerialName("inline_query") public val inlineQuery: InlineQuery? = null,
    @SerialName("chosen_inline_result") public val chosenInlineResult: ChosenInlineResult? = null,
    @SerialName("callback_query") public val callbackQuery: CallbackQuery? = null,
    @SerialName("shipping_query") public val shippingQuery: ShippingQuery? = null,
    @SerialName("pre_checkout_query") public val preCheckoutQuery: PreCheckoutQuery? = null,
    public val poll: Poll? = null,
    @SerialName("poll_answer") public val pollAnswer: PollAnswer? = null,
    @SerialName("my_chat_member") public val myChatMember: ChatMemberUpdated? = null,
    @SerialName("chat_member") public val chatMember: ChatMemberUpdated? = null,
    @SerialName("chat_join_request") public val chatJoinRequest: ChatJoinRequest? = null
)