package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class SuccessfulPayment(
    public val currency: String,
    @SerialName("total_amount") public val totalAmount: Int,
    @SerialName("invoice_payload") public val invoicePayload: String,
    @SerialName("shipping_option_id") public val shippingOptionId: String? = null,
    @SerialName("order_info") public val orderInfo: OrderInfo? = null,
    @SerialName("telegram_payment_charge_id") public val telegramPaymentChargeId: String,
    @SerialName("provider_payment_charge_id") public val providerPaymentChargeId: String
)