package io.ciogram.types

import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonContentPolymorphicSerializer
import kotlinx.serialization.json.JsonElement
import kotlinx.serialization.json.jsonObject

@Serializable(with = ReplyMarkupSerializer::class)
public sealed class ReplyMarkup

internal object ReplyMarkupSerializer : JsonContentPolymorphicSerializer<ReplyMarkup>(ReplyMarkup::class) {
    override fun selectDeserializer(element: JsonElement): DeserializationStrategy<out ReplyMarkup> {
        return when {
            "keyboard" in element.jsonObject -> ReplyKeyboardMarkup.serializer()
            "inline_keyboard" in element.jsonObject -> InlineKeyboardMarkup.serializer()
            "force_reply" in element.jsonObject -> ForceReply.serializer()
            "remove_keyboard" in element.jsonObject -> ReplyKeyboardRemove.serializer()
            else -> throw IllegalArgumentException("Unsupported reply keyboard type")
        }
    }
}