package io.ciogram.types

import kotlinx.serialization.*

@Serializable
public data class EncryptedPassportElement(
    public val type: String,
    public val data: String? = null,
    @SerialName("phone_number") public val phoneNumber: String? = null,
    public val email: String? = null,
    public val files: List<PassportFile>? = null,
    @SerialName("front_side") public val frontSide: PassportFile? = null,
    @SerialName("reverse_side") public val reverseSide: PassportFile? = null,
    public val selfie: PassportFile? = null,
    public val translation: List<PassportFile>? = null,
    public val hash: String
)