package io.ciogram.client.core

import io.ciogram.types.*

public interface TelegramClient {
    public val token: String?

    public suspend fun getUpdates(
        offset: Int? = null,
        limit: Int? = null,
        timeout: Int? = null,
        allowedUpdates: List<String>? = null,
        token: String? = null,
        serverUrl: String? = null
    ): List<Update>

    public suspend fun setWebhook(
        url: String,
        certificate: LocalInputFile? = null,
        ipAddress: String? = null,
        maxConnections: Int? = null,
        allowedUpdates: List<String>? = null,
        dropPendingUpdates: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun deleteWebhook(
        dropPendingUpdates: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun getWebhookInfo(
        token: String? = null,
        serverUrl: String? = null
    ): WebhookInfo

    public suspend fun getMe(
        token: String? = null,
        serverUrl: String? = null
    ): User

    public suspend fun logOut(
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun close(
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun sendMessage(
        chatId: String,
        text: String,
        parseMode: String? = null,
        entities: List<MessageEntity>? = null,
        disableWebPagePreview: Boolean? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun forwardMessage(
        chatId: String,
        fromChatId: String,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        messageId: Int,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun copyMessage(
        chatId: String,
        fromChatId: String,
        messageId: Int,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): MessageId

    public suspend fun sendPhoto(
        chatId: String,
        photo: InputFile,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendAudio(
        chatId: String,
        audio: InputFile,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        duration: Int? = null,
        performer: String? = null,
        title: String? = null,
        thumb: InputFile? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendDocument(
        chatId: String,
        document: InputFile,
        thumb: InputFile? = null,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        disableContentTypeDetection: Boolean? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendVideo(
        chatId: String,
        video: InputFile,
        duration: Int? = null,
        width: Int? = null,
        height: Int? = null,
        thumb: InputFile? = null,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        supportsStreaming: Boolean? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendAnimation(
        chatId: String,
        animation: InputFile,
        duration: Int? = null,
        width: Int? = null,
        height: Int? = null,
        thumb: InputFile? = null,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendVoice(
        chatId: String,
        voice: InputFile,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        duration: Int? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendVideoNote(
        chatId: String,
        videoNote: InputFile,
        duration: Int? = null,
        length: Int? = null,
        thumb: InputFile? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendMediaGroup(
        chatId: String,
        media: List<InputMedia>,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    ): List<Message>

    public suspend fun sendLocation(
        chatId: String,
        latitude: Float,
        longitude: Float,
        horizontalAccuracy: Float? = null,
        livePeriod: Int? = null,
        heading: Int? = null,
        proximityAlertRadius: Int? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageLiveLocation(
        chatId: String,
        messageId: Int,
        latitude: Float,
        longitude: Float,
        horizontalAccuracy: Float? = null,
        heading: Int? = null,
        proximityAlertRadius: Int? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageLiveLocation(
        inlineMessageId: String,
        latitude: Float,
        longitude: Float,
        horizontalAccuracy: Float? = null,
        heading: Int? = null,
        proximityAlertRadius: Int? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun stopMessageLiveLocation(
        chatId: String,
        messageId: Int,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun stopMessageLiveLocation(
        inlineMessageId: String,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun sendVenue(
        chatId: String,
        latitude: Float,
        longitude: Float,
        title: String,
        address: String,
        foursquareId: String? = null,
        foursquareType: String? = null,
        googlePlaceId: String? = null,
        googlePlaceType: String? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendContact(
        chatId: String,
        phoneNumber: String,
        firstName: String,
        lastName: String? = null,
        vcard: String? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendPoll(
        chatId: String,
        question: String,
        options: List<String>,
        isAnonymous: Boolean? = null,
        type: String? = null,
        allowsMultipleAnswers: Boolean? = null,
        correctOptionId: Int? = null,
        explanation: String? = null,
        explanationParseMode: String? = null,
        explanationEntities: List<MessageEntity>? = null,
        openPeriod: Int? = null,
        closeDate: Int? = null,
        isClosed: Boolean? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendDice(
        chatId: String,
        emoji: String? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun sendChatAction(
        chatId: String,
        action: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun getUserProfilePhotos(
        userId: Long,
        offset: Int? = null,
        limit: Int? = null,
        token: String? = null,
        serverUrl: String? = null
    ): UserProfilePhotos

    public suspend fun getFile(
        fileId: String,
        token: String? = null,
        serverUrl: String? = null
    ): File

    public suspend fun banChatMember(
        chatId: String,
        userId: Long,
        untilDate: Int? = null,
        revokeMessages: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun unbanChatMember(
        chatId: String,
        userId: Long,
        onlyIfBanned: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun restrictChatMember(
        chatId: String,
        userId: Long,
        permissions: ChatPermissions,
        untilDate: Int? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun promoteChatMember(
        chatId: String,
        userId: Long,
        isAnonymous: Boolean? = null,
        canManageChat: Boolean? = null,
        canPostMessages: Boolean? = null,
        canEditMessages: Boolean? = null,
        canDeleteMessages: Boolean? = null,
        canManageVoiceChats: Boolean? = null,
        canRestrictMembers: Boolean? = null,
        canPromoteMembers: Boolean? = null,
        canChangeInfo: Boolean? = null,
        canInviteUsers: Boolean? = null,
        canPinMessages: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setChatAdministratorCustomTitle(
        chatId: String,
        userId: Long,
        customTitle: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun banChatSenderChat(
        chatId: String,
        senderChatId: Long,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun unbanChatSenderChat(
        chatId: String,
        senderChatId: Long,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setChatPermissions(
        chatId: String,
        permissions: ChatPermissions,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun exportChatInviteLink(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    ): String

    public suspend fun createChatInviteLink(
        chatId: String,
        name: String? = null,
        expireDate: Int? = null,
        memberLimit: Int? = null,
        createsJoinRequest: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    ): ChatInviteLink

    public suspend fun editChatInviteLink(
        chatId: String,
        inviteLink: String,
        name: String? = null,
        expireDate: Int? = null,
        memberLimit: Int? = null,
        createsJoinRequest: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    ): ChatInviteLink

    public suspend fun revokeChatInviteLink(
        chatId: String,
        inviteLink: String,
        token: String? = null,
        serverUrl: String? = null
    ): ChatInviteLink

    public suspend fun approveChatJoinRequest(
        chatId: String,
        userId: Long,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun declineChatJoinRequest(
        chatId: String,
        userId: Long,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setChatPhoto(
        chatId: String,
        photo: LocalInputFile,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun deleteChatPhoto(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setChatTitle(
        chatId: String,
        title: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setChatDescription(
        chatId: String,
        description: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun pinChatMessage(
        chatId: String,
        messageId: Int,
        disableNotification: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun unpinChatMessage(
        chatId: String,
        messageId: Int? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun unpinAllChatMessages(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun leaveChat(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun getChat(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    ): Chat

    public suspend fun getChatAdministrators(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    ): List<ChatMember>

    public suspend fun getChatMemberCount(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    ): Int

    public suspend fun getChatMember(
        chatId: String,
        userId: Long,
        token: String? = null,
        serverUrl: String? = null
    ): ChatMember

    public suspend fun setChatStickerSet(
        chatId: String,
        stickerSetName: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun deleteChatStickerSet(
        chatId: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun answerCallbackQuery(
        callbackQueryId: String,
        text: String? = null,
        showAlert: Boolean? = null,
        url: String? = null,
        cacheTime: Int? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setMyCommands(
        commands: List<BotCommand>,
        scope: BotCommandScope? = null,
        languageCode: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun deleteMyCommands(
        scope: BotCommandScope? = null,
        languageCode: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun getMyCommands(
        scope: BotCommandScope? = null,
        languageCode: String? = null,
        token: String? = null,
        serverUrl: String? = null
    ): List<BotCommand>

    public suspend fun editMessageText(
        chatId: String,
        messageId: Int,
        text: String,
        parseMode: String? = null,
        entities: List<MessageEntity>? = null,
        disableWebPagePreview: Boolean? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageText(
        inlineMessageId: String,
        text: String,
        parseMode: String? = null,
        entities: List<MessageEntity>? = null,
        disableWebPagePreview: Boolean? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun editMessageCaption(
        chatId: String,
        messageId: Int,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageCaption(
        inlineMessageId: String,
        caption: String? = null,
        parseMode: String? = null,
        captionEntities: List<MessageEntity>? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun editMessageMedia(
        chatId: String,
        messageId: Int,
        media: InputMedia,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageMedia(
        inlineMessageId: String,
        media: InputMedia,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun editMessageReplyMarkup(
        chatId: String,
        messageId: Int,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun editMessageReplyMarkup(
        inlineMessageId: String,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun stopPoll(
        chatId: String,
        messageId: Int,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Poll

    public suspend fun deleteMessage(
        chatId: String,
        messageId: Int,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun sendSticker(
        chatId: String,
        sticker: InputFile,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: ReplyMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun getStickerSet(
        name: String,
        token: String? = null,
        serverUrl: String? = null
    ): StickerSet

    public suspend fun uploadStickerFile(
        userId: Long,
        pngSticker: LocalInputFile,
        token: String? = null,
        serverUrl: String? = null
    ): File

    public suspend fun createNewStickerSet(
        userId: Long,
        name: String,
        title: String,
        pngSticker: InputFile? = null,
        tgsSticker: LocalInputFile? = null,
        emojis: String,
        containsMasks: Boolean? = null,
        maskPosition: MaskPosition? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun addStickerToSet(
        userId: Long,
        name: String,
        pngSticker: InputFile? = null,
        tgsSticker: LocalInputFile? = null,
        emojis: String,
        maskPosition: MaskPosition? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setStickerPositionInSet(
        sticker: String,
        position: Int,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun deleteStickerFromSet(
        sticker: String,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setStickerSetThumb(
        name: String,
        userId: Long,
        thumb: InputFile? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun answerInlineQuery(
        inlineQueryId: String,
        results: List<InlineQueryResult>,
        cacheTime: Int? = null,
        isPersonal: Boolean? = null,
        nextOffset: String? = null,
        switchPmText: String? = null,
        switchPmParameter: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun sendInvoice(
        chatId: String,
        title: String,
        description: String,
        payload: String,
        providerToken: String,
        currency: String,
        prices: List<LabeledPrice>,
        maxTipAmount: Int? = null,
        suggestedTipAmounts: List<Int>? = null,
        startParameter: String? = null,
        providerData: String? = null,
        photoUrl: String? = null,
        photoSize: Int? = null,
        photoWidth: Int? = null,
        photoHeight: Int? = null,
        needName: Boolean? = null,
        needPhoneNumber: Boolean? = null,
        needEmail: Boolean? = null,
        needShippingAddress: Boolean? = null,
        sendPhoneNumberToProvider: Boolean? = null,
        sendEmailToProvider: Boolean? = null,
        isFlexible: Boolean? = null,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun answerShippingQuery(
        shippingQueryId: String,
        ok: Boolean,
        shippingOptions: List<ShippingOption>? = null,
        errorMessage: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun answerPreCheckoutQuery(
        preCheckoutQueryId: String,
        ok: Boolean,
        errorMessage: String? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun setPassportDataErrors(
        userId: Long,
        errors: List<PassportElementError>,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun sendGame(
        chatId: Long,
        gameShortName: String,
        disableNotification: Boolean? = null,
        protectContent: Boolean? = null,
        replyToMessageId: Int? = null,
        allowSendingWithoutReply: Boolean? = null,
        replyMarkup: InlineKeyboardMarkup? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun setGameScore(
        chatId: String,
        messageId: Int,
        userId: Long,
        score: Int,
        force: Boolean? = null,
        disableEditMessage: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    ): Message

    public suspend fun setGameScore(
        inlineMessageId: String,
        userId: Long,
        score: Int,
        force: Boolean? = null,
        disableEditMessage: Boolean? = null,
        token: String? = null,
        serverUrl: String? = null
    )

    public suspend fun getGameHighScores(
        chatId: String,
        messageId: Int,
        userId: Long,
        token: String? = null,
        serverUrl: String? = null
    ): List<GameHighScore>

    public suspend fun getGameHighScores(
        inlineMessageId: String,
        userId: Long,
        token: String? = null,
        serverUrl: String? = null
    ): List<GameHighScore>

    public fun closeEngine()
}