/*
 * Decompiled with CFR 0.152.
 */
package io.chapp.commons.locale;

import io.chapp.commons.locale.Bundle;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

class BundleValidator {
    private final Bundle annotation;
    private final Element annotatedElement;
    private final Messager messager;
    private Boolean valid;
    private Map<String, List<String>> parameterTypes = new HashMap<String, List<String>>();

    BundleValidator(Bundle annotation, Element annotatedElement, Messager messager) {
        this.annotation = annotation;
        this.annotatedElement = annotatedElement;
        this.messager = messager;
    }

    public boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        this.valid = this.validateDefaultBundle() && this.validateRequiredLocales();
        return this.valid;
    }

    private boolean validateDefaultBundle() {
        return this.validateBundle(null);
    }

    private boolean validateRequiredLocales() {
        boolean success = true;
        for (String locale : this.annotation.requiredLocales()) {
            if (this.validateBundle(locale)) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateBundle(String localeName) {
        String locale = localeName == null ? "default" : localeName;
        String bundlePath = this.getBundleName();
        if (localeName != null) {
            bundlePath = bundlePath + "_" + locale;
        }
        String resourcePath = "/" + bundlePath + ".properties";
        InputStream resourceBundle = this.getClass().getResourceAsStream(resourcePath);
        if (resourceBundle == null) {
            this.error("Missing locale '" + locale + "' for resource bundle '" + this.getBundleName() + "'");
            return false;
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(resourceBundle);
            }
            finally {
                resourceBundle.close();
            }
        }
        catch (IOException e) {
            this.error("Invalid Format for resource bundle '" + this.getBundleName() + "' with locale '" + locale + "': " + e.getMessage());
            return false;
        }
        return this.validateBundle(properties, locale, localeName == null);
    }

    private boolean validateBundle(Properties properties, String locale, boolean storeFormats) {
        boolean success = true;
        for (Map.Entry<Object, Object> entry : this.getDefaultEntries().entrySet()) {
            String key = entry.getKey().toString();
            if (this.isEntryPresent(properties, key, locale) && this.isEntryValid(key, properties.getProperty(key), locale, storeFormats)) continue;
            success = false;
        }
        return success;
    }

    private boolean isEntryValid(String key, String message, String locale, boolean storeFormats) {
        try {
            MessageFormat messageFormat = new MessageFormat(message);
            ArrayList<String> types = new ArrayList<String>();
            for (Format format : messageFormat.getFormatsByArgumentIndex()) {
                types.add(this.getType(format));
            }
            if (storeFormats) {
                this.parameterTypes.put(key, types);
            } else if (!this.areParametersValid(this.parameterTypes.get(key), types, locale, key)) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            this.error("Invalid pattern for entry '" + key + "' in resource bundle '" + this.getBundleName() + "' with locale '" + locale + "': " + e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    private boolean areParametersValid(List<String> expectedTypes, List<String> realTypes, String locale, String key) {
        if (expectedTypes.size() != realTypes.size()) {
            this.error("Parameter count mismatch in message '" + key + "' of resource bundle '" + this.getBundleName() + "'.\nThe '" + locale + "' expects " + realTypes.size() + " parameters but the default locale expects " + expectedTypes.size() + " parameters.");
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            String expected;
            String actual = realTypes.get(i);
            if (actual.equalsIgnoreCase(expected = expectedTypes.get(i))) continue;
            this.error("Parameter count mismatch in message '" + key + "' of resource bundle '" + this.getBundleName() + "'.\nDefault locale: " + expected + "\n" + locale + ": " + actual);
        }
        return true;
    }

    private boolean isEntryPresent(Properties properties, String key, String locale) {
        if (!properties.containsKey(key)) {
            this.error("Missing entry '" + key + "' for required locale '" + locale + "' for resource bundle '" + this.getBundleName() + "'");
            return false;
        }
        return true;
    }

    private String getType(Format format) {
        if (format instanceof DateFormat) {
            return "Date";
        }
        if (format instanceof NumberFormat) {
            return "Number";
        }
        return "Object";
    }

    public String getBundleName() {
        return this.annotation.bundleName();
    }

    public String getTargetQualifiedClassName() {
        return this.annotation.className();
    }

    public String getTargetPackage() {
        int index = this.annotation.className().lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return this.annotation.className().substring(0, index);
    }

    public Map<String, List<String>> getParameterTypes() {
        return this.parameterTypes;
    }

    public String getTargetClassName() {
        int index = this.annotation.className().lastIndexOf(46);
        return this.annotation.className().substring(index + 1);
    }

    public void info(String message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message, this.annotatedElement);
    }

    public void error(String message) {
        this.error(message, this.annotatedElement);
    }

    public void error(String message, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
    }

    public Properties getDefaultEntries() {
        Properties entries = new Properties();
        InputStream stream = this.getClass().getResourceAsStream("/" + this.getBundleName() + ".properties");
        if (stream == null) {
            this.error("No default resource bundle found for name '" + this.getBundleName() + "'");
        } else {
            try {
                try {
                    entries.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (IOException e) {
                this.error("Invalid contents for resource bundle: " + e.getMessage());
            }
        }
        return entries;
    }
}

