/*
 * Decompiled with CFR 0.152.
 */
package io.chapp.commons.locale;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.chapp.commons.locale.Bundle;
import io.chapp.commons.locale.BundleValidator;
import io.chapp.commons.locale.Bundles;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"io.chapp.commons.locale.Bundle", "io.chapp.commons.locale.Bundles"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class BundleProcessor
extends AbstractProcessor {
    private final Template template;

    public BundleProcessor() throws IOException {
        this(new Configuration(Configuration.VERSION_2_3_23));
    }

    public BundleProcessor(Configuration configuration) throws IOException {
        configuration.setClassForTemplateLoading(BundleProcessor.class, "/io/chapp/commons/locale/");
        this.template = configuration.getTemplate("localized-class.ftl");
    }

    private static String toUpperCamelCase(String input) {
        String[] parts = input.split("[._-]");
        StringBuilder builder = new StringBuilder(input.length() - parts.length + 1);
        for (String part : parts) {
            builder.append(Character.toUpperCase(part.charAt(0))).append(part.substring(1).toLowerCase());
        }
        return builder.toString();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(Bundle.class)) {
            this.process(element.getAnnotation(Bundle.class), element);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(Bundles.class)) {
            for (Bundle bundle : element.getAnnotation(Bundles.class).value()) {
                this.process(bundle, element);
            }
        }
        return false;
    }

    private void process(Bundle resourceBundle, Element annotatedElement) {
        BundleValidator validator = new BundleValidator(resourceBundle, annotatedElement, this.processingEnv.getMessager());
        try {
            if (validator.isValid()) {
                this.process(validator);
            }
        }
        catch (IOException e) {
            validator.error(e.getMessage());
        }
    }

    private void process(BundleValidator classData) throws IOException {
        classData.info("Generating Localization class for " + classData.getBundleName());
        JavaFileObject object = this.processingEnv.getFiler().createSourceFile(classData.getTargetQualifiedClassName(), new Element[0]);
        Map<String, Object> model = this.buildModel(classData);
        PrintWriter writer = new PrintWriter(object.openWriter());
        try {
            this.template.process(model, (Writer)writer);
        }
        catch (TemplateException e) {
            throw new IOException("Template Error: " + e.getMessage(), e);
        }
        finally {
            writer.close();
        }
    }

    private Map<String, Object> buildModel(BundleValidator classData) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (classData.getTargetPackage() != null) {
            model.put("package", classData.getTargetPackage());
        }
        model.put("className", classData.getTargetClassName());
        model.put("bundleName", classData.getBundleName());
        ArrayList resources = new ArrayList();
        for (Object key : classData.getDefaultEntries().keySet()) {
            HashMap<String, Object> resource = new HashMap<String, Object>();
            resource.put("key", key.toString());
            resource.put("methodName", "get" + BundleProcessor.toUpperCamelCase(key.toString()));
            resource.put("parameterTypes", classData.getParameterTypes().get(key.toString()));
            resources.add(resource);
        }
        model.put("resources", resources);
        return model;
    }
}

