<#--

    Copyright © 2016 Thomas Biesaart (thomas.biesaart@gmail.com)

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

-->
<#if package??>
package ${package};
</#if>

import java.util.*;
import java.text.MessageFormat;

/**
 * This class was generated by ChappIO Commons Locale's Bundle annotation and provides statically checked
 * access to /${bundleName} and all implemented locales.
 * <p>
 * For every message that exists in /${bundleName} you will find two getters that allow you to fetch the message.
 * The first method will use the default locale for the current system. The second method will use a specified locale.
 * <p>
 * Full documentation can be found on: <a href="https://github.com/ChappIO/commons/wiki/Commons-Locale">ChappIO Commons GitHub</a
 *
 * @author ChappIO's Bundle
 */
public class ${className} {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("${bundleName}");
    private static final Map<Locale, ResourceBundle> localizedBundles = new HashMap<Locale, ResourceBundle>();

    private ${className}() {
        // You shall not have an instance of this... Sorry.
    }

    private static String getResource(String key, Object... parameters) {
        return MessageFormat.format(bundle.getString(key), parameters);
    }

    private static String getResource(String key, Locale locale, Object... parameters) {
        ResourceBundle bundle = localizedBundles.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle("${bundleName}", locale);
            localizedBundles.put(locale, bundle);
        }
        return MessageFormat.format(bundle.getString(key), parameters);
    }
    <#list resources as resource>

    /**
     * Get the ${resource.key} message from the ${bundleName} resource bundle using the default system locale.
     *
    <#list resource.parameterTypes as param>
     * @param par${param?index} A parameter for the message of type ${param}
    </#list>
     * @returns the formatter message according to the resource bundle in the given locale
     */
    public static String ${resource.methodName}(<#list resource.parameterTypes as param>${param} par${param?index}<#if param?has_next>, </#if></#list>) {
        return getResource("${resource.key}"<#list resource.parameterTypes as param>, par${param?index}</#list>);
    }

    /**
     * Get the ${resource.key} message from the ${bundleName} resource bundle using a specified locale.
     *
     * @param locale the locale for which to fetch this message
    <#list resource.parameterTypes as param>
     * @param par${param?index} A parameter for the message of type ${param}
    </#list>
     * @returns the formatter message according to the resource bundle in the given locale
     */
    public static String ${resource.methodName}(Locale locale<#list resource.parameterTypes as param>, ${param} par${param?index}</#list>) {
        return getResource("${resource.key}", locale<#list resource.parameterTypes as param>, par${param?index}</#list>);
    }
    </#list>
}