/**
 * Copyright © 2016 Thomas Biesaart (thomas.biesaart@gmail.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.chapp.commons.locale;

/**
 * This annotation represents the configuration of generated resource bundles using ChappIO Commons Locale.
 * Place this annotation on any class (generally on the main class of your application) to instruct the compiler to
 * generate a statically accessible class that allows you to retrieve your messages.
 * <p>
 * This annotation activates the following behaviors:
 * <ul>
 * <li>It generates a class in the target chosen in the <strong>className</strong> parameter</li>
 * <li>It validates all locales defined in <strong>requiredLocales</strong> for completeness and parameter consistency</li>
 * </ul>
 * The generated class will contain a static getter for every defined message. It will accept parameters based on the
 * parameters defined in the message itself.
 * <p>
 * Full documentation can be found on: <a href="https://github.com/ChappIO/commons/wiki/Commons-Locale">ChappIO Commons GitHub</a>
 *
 * @author Thomas Biesaart
 */
public @interface Bundle {
    /**
     * The base name of the resource bundle.
     * If you create your resource bundle at <strong>/org/example/logging.properties</strong> then the base name will
     * be <strong>org/example/logging.properties</strong>. Note the missing <strong>/</strong> from the name.
     *
     * @return the base bundle name
     */
    String bundleName();

    /**
     * The fully qualified path to the accessor class.
     * This is where the compiler will generate the static class from which you can fetch your messages. This must
     * be a non-existing class or otherwise compilation will fail.
     *
     * @return the target qualified task name
     */
    String className();

    /**
     * List the validated locales.
     * All locales listed in this array must:
     * <ul>
     * <li>Implement the all the messages that are implemented by the default locale</li>
     * <li>Adhere to the same parameter types as the default locale</li>
     * </ul>
     *
     * @return all required locales
     */
    String[] requiredLocales() default {};
}
