/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.test;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.RecipePipeline;
import io.cdap.wrangler.executor.RecipePipelineExecutor;
import io.cdap.wrangler.parser.GrammarBasedParser;
import io.cdap.wrangler.parser.MigrateToV2;
import io.cdap.wrangler.registry.CompositeDirectiveRegistry;
import io.cdap.wrangler.registry.DirectiveRegistry;
import io.cdap.wrangler.registry.SystemDirectiveRegistry;
import io.cdap.wrangler.test.api.TestRecipe;
import java.util.ArrayList;

public final class TestingRig {
    private TestingRig() {
    }

    public static RecipePipeline pipeline(Class<? extends Directive> directive, TestRecipe recipe) throws RecipeException, DirectiveParseException, DirectiveLoadException {
        TestingRig.verify(directive);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(directive.getPackage().getName());
        CompositeDirectiveRegistry registry = new CompositeDirectiveRegistry(new DirectiveRegistry[]{new SystemDirectiveRegistry(packages)});
        String migrate = new MigrateToV2(recipe.toArray()).migrate();
        GrammarBasedParser parser = new GrammarBasedParser("system", migrate, (DirectiveRegistry)registry);
        parser.initialize(null);
        RecipePipelineExecutor pipeline = new RecipePipelineExecutor();
        pipeline.initialize((RecipeParser)parser, null);
        return pipeline;
    }

    public static RecipeParser parser(Class<? extends Directive> directive, String[] recipe) throws DirectiveParseException, DirectiveLoadException {
        TestingRig.verify(directive);
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(directive.getCanonicalName());
        CompositeDirectiveRegistry registry = new CompositeDirectiveRegistry(new DirectiveRegistry[]{new SystemDirectiveRegistry()});
        String migrate = new MigrateToV2(recipe).migrate();
        GrammarBasedParser parser = new GrammarBasedParser("system", migrate, (DirectiveRegistry)registry);
        parser.initialize(null);
        return parser;
    }

    private static void verify(Class<? extends Directive> directive) {
        String classz = directive.getCanonicalName();
        Plugin plugin = directive.getAnnotation(Plugin.class);
        if (plugin == null || !plugin.type().equalsIgnoreCase("directive")) {
            throw new IllegalArgumentException(String.format("Class '%s' @Plugin annotation is not of type '%s', Set it as @Plugin(type=UDD.Type)", classz, "directive"));
        }
        Name name = directive.getAnnotation(Name.class);
        if (name == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing @Name annotation. E.g. @Name(\"directive-name\")", classz));
        }
        Description description = directive.getAnnotation(Description.class);
        if (description == null) {
            throw new IllegalArgumentException(String.format("Class '%s' is missing @Description annotation. E.g. @Description(\"this is what my directive does\")", classz));
        }
    }
}

