/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.workspace;

import io.cdap.wrangler.dataset.workspace.DataType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WorkspaceMeta {
    private final String name;
    private final String scope;
    private final DataType type;
    private final Map<String, String> properties;

    protected WorkspaceMeta(String name, String scope, DataType type, Map<String, String> properties) {
        this.name = name;
        this.scope = scope;
        this.type = type;
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public String getName() {
        return this.name;
    }

    public String getScope() {
        return this.scope;
    }

    public DataType getType() {
        return this.type;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceMeta that = (WorkspaceMeta)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.scope, that.scope) && this.type == that.type && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.scope, this.type, this.properties});
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static class Builder<T extends Builder> {
        protected final String name;
        protected String scope;
        protected DataType type;
        protected Map<String, String> properties;

        Builder(String name) {
            this.name = name;
            this.properties = new HashMap<String, String>();
            this.scope = "default";
            this.type = DataType.BINARY;
        }

        public T setScope(String scope) {
            this.scope = scope;
            return (T)this;
        }

        public T setType(DataType type) {
            this.type = type;
            return (T)this;
        }

        public T setProperties(Map<String, String> properties) {
            this.properties.clear();
            this.properties.putAll(properties);
            return (T)this;
        }

        public WorkspaceMeta build() {
            return new WorkspaceMeta(this.name, this.scope, this.type, this.properties);
        }
    }
}

