/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.workspace;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.CloseableIterator;
import io.cdap.cdap.internal.io.SchemaTypeAdapter;
import io.cdap.cdap.spi.data.StructuredRow;
import io.cdap.cdap.spi.data.StructuredTable;
import io.cdap.cdap.spi.data.StructuredTableContext;
import io.cdap.cdap.spi.data.TableNotFoundException;
import io.cdap.cdap.spi.data.table.StructuredTableId;
import io.cdap.cdap.spi.data.table.StructuredTableSpecification;
import io.cdap.cdap.spi.data.table.field.Field;
import io.cdap.cdap.spi.data.table.field.FieldType;
import io.cdap.cdap.spi.data.table.field.Fields;
import io.cdap.cdap.spi.data.table.field.Range;
import io.cdap.wrangler.dataset.workspace.DataType;
import io.cdap.wrangler.dataset.workspace.RequestDeserializer;
import io.cdap.wrangler.dataset.workspace.Workspace;
import io.cdap.wrangler.dataset.workspace.WorkspaceMeta;
import io.cdap.wrangler.dataset.workspace.WorkspaceNotFoundException;
import io.cdap.wrangler.proto.Namespace;
import io.cdap.wrangler.proto.NamespacedId;
import io.cdap.wrangler.proto.Request;
import io.cdap.wrangler.proto.WorkspaceIdentifier;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class WorkspaceDataset {
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).registerTypeAdapter(Request.class, (Object)new RequestDeserializer()).create();
    private static final String NAMESPACE_COL = "namespace";
    private static final String GENERATION_COL = "generation";
    private static final String ID_COL = "id";
    private static final String NAME_COL = "name";
    private static final String TYPE_COL = "type";
    private static final String SCOPE_COL = "scope";
    private static final String CREATED_COL = "created";
    private static final String UPDATED_COL = "updated";
    private static final String PROPERTIES_COL = "properties";
    private static final String DATA_COL = "data";
    private static final String REQUEST_COL = "request";
    private static final StructuredTableId TABLE_ID = new StructuredTableId("workspaces");
    public static final StructuredTableSpecification TABLE_SPEC = new StructuredTableSpecification.Builder().withId(TABLE_ID).withFields(new FieldType[]{new FieldType("namespace", FieldType.Type.STRING), new FieldType("generation", FieldType.Type.LONG), new FieldType("id", FieldType.Type.STRING), new FieldType("name", FieldType.Type.STRING), new FieldType("type", FieldType.Type.STRING), new FieldType("scope", FieldType.Type.STRING), new FieldType("created", FieldType.Type.LONG), new FieldType("updated", FieldType.Type.LONG), new FieldType("properties", FieldType.Type.STRING), new FieldType("data", FieldType.Type.BYTES), new FieldType("request", FieldType.Type.STRING)}).withPrimaryKeys(new String[]{"namespace", "generation", "id"}).build();
    public static final String DEFAULT_SCOPE = "default";
    private final StructuredTable table;

    public WorkspaceDataset(StructuredTable table) {
        this.table = table;
    }

    public static WorkspaceDataset get(StructuredTableContext context) {
        try {
            StructuredTable table = context.getTable(TABLE_ID);
            return new WorkspaceDataset(table);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(String.format("System table '%s' does not exist. Please check your system environment.", TABLE_ID.getName()), e);
        }
    }

    public NamespacedId createWorkspace(Namespace namespace, WorkspaceMeta meta) throws IOException {
        NamespacedId id = new NamespacedId(namespace, UUID.randomUUID().toString());
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Workspace workspace = ((Workspace.Builder)((Workspace.Builder)((Workspace.Builder)Workspace.builder(id, meta.getName()).setCreated(now).setUpdated(now).setScope(meta.getScope())).setProperties(meta.getProperties())).setType(meta.getType())).build();
        this.table.upsert(this.toFields(workspace));
        return id;
    }

    public void writeWorkspaceMeta(NamespacedId id, WorkspaceMeta meta) throws IOException {
        Workspace existing = this.readWorkspace(id);
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Workspace.Builder updated = Workspace.builder(id, meta.getName());
        if (existing != null) {
            updated.setCreated(existing.getCreated()).setData(existing.getData()).setRequest(existing.getRequest());
        } else {
            updated.setCreated(now);
        }
        ((Workspace.Builder)((Workspace.Builder)updated.setUpdated(now).setScope(meta.getScope())).setProperties(meta.getProperties())).setType(meta.getType());
        this.table.upsert(this.toFields(updated.build()));
    }

    public Workspace getWorkspace(NamespacedId id) throws WorkspaceNotFoundException, IOException {
        Workspace workspace = this.readWorkspace(id);
        if (workspace == null) {
            throw new WorkspaceNotFoundException(String.format("Workspace '%s' does not exist.", id.getId()));
        }
        return workspace;
    }

    public boolean hasWorkspace(NamespacedId id) throws IOException {
        Optional row = this.table.read(this.getKey(id));
        return row.isPresent();
    }

    public List<WorkspaceIdentifier> listWorkspaces(Namespace namespace, String scope) throws IOException {
        ArrayList<WorkspaceIdentifier> values = new ArrayList<WorkspaceIdentifier>();
        ArrayList<Field> namespaceKey = new ArrayList<Field>(2);
        namespaceKey.add(Fields.stringField((String)NAMESPACE_COL, (String)namespace.getName()));
        namespaceKey.add(Fields.longField((String)GENERATION_COL, (Long)namespace.getGeneration()));
        Range range = Range.singleton(namespaceKey);
        try (CloseableIterator rowIter = this.table.scan(range, Integer.MAX_VALUE);){
            while (rowIter.hasNext()) {
                StructuredRow row = (StructuredRow)rowIter.next();
                Workspace workspace = this.readWorkspace(row);
                if (!scope.equals(workspace.getScope())) continue;
                values.add(new WorkspaceIdentifier(workspace.getNamespacedId().getId(), workspace.getName()));
            }
        }
        return values;
    }

    public void updateWorkspaceProperties(NamespacedId id, Map<String, String> properties) throws WorkspaceNotFoundException, IOException {
        Workspace existing = this.getWorkspace(id);
        Workspace updated = ((Workspace.Builder)Workspace.builder(existing).setProperties(properties)).setUpdated(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
        this.table.upsert(this.toFields(updated));
    }

    public void updateWorkspaceRequest(NamespacedId id, Request request) throws WorkspaceNotFoundException, IOException {
        Workspace existing = this.getWorkspace(id);
        Workspace updated = Workspace.builder(existing).setRequest(request).setUpdated(System.currentTimeMillis() / 1000L).build();
        this.table.upsert(this.toFields(updated));
    }

    public void updateWorkspaceData(NamespacedId id, DataType dataType, byte[] data) throws WorkspaceNotFoundException, IOException {
        Workspace existing = this.getWorkspace(id);
        Workspace updated = ((Workspace.Builder)Workspace.builder(existing).setType(dataType)).setData(data).setUpdated(System.currentTimeMillis() / 1000L).build();
        this.table.upsert(this.toFields(updated));
    }

    public void deleteWorkspace(NamespacedId id) throws IOException {
        this.table.delete(this.getKey(id));
    }

    public int deleteScope(Namespace namespace, String scope) throws IOException {
        ArrayList<Field> key = new ArrayList<Field>(2);
        key.add(Fields.stringField((String)NAMESPACE_COL, (String)namespace.getName()));
        key.add(Fields.longField((String)GENERATION_COL, (Long)namespace.getGeneration()));
        Range range = Range.singleton(key);
        try (CloseableIterator rowIter = this.table.scan(range, Integer.MAX_VALUE);){
            int count = 0;
            while (rowIter.hasNext()) {
                StructuredRow row = (StructuredRow)rowIter.next();
                Workspace workspace = this.readWorkspace(row);
                if (!scope.equals(workspace.getScope())) continue;
                this.deleteWorkspace(workspace.getNamespacedId());
                ++count;
            }
            int n = count;
            return n;
        }
    }

    private List<Field<?>> toFields(Workspace workspace) {
        byte[] data;
        ArrayList fields = new ArrayList(11);
        fields.add(Fields.stringField((String)NAMESPACE_COL, (String)workspace.getNamespacedId().getNamespace().getName()));
        fields.add(Fields.longField((String)GENERATION_COL, (Long)workspace.getNamespacedId().getNamespace().getGeneration()));
        fields.add(Fields.stringField((String)ID_COL, (String)workspace.getNamespacedId().getId()));
        fields.add(Fields.stringField((String)NAME_COL, (String)workspace.getName()));
        fields.add(Fields.stringField((String)SCOPE_COL, (String)workspace.getScope()));
        fields.add(Fields.stringField((String)TYPE_COL, (String)workspace.getType().name()));
        fields.add(Fields.stringField((String)PROPERTIES_COL, (String)GSON.toJson(workspace.getProperties())));
        fields.add(Fields.longField((String)CREATED_COL, (Long)workspace.getCreated()));
        fields.add(Fields.longField((String)UPDATED_COL, (Long)workspace.getUpdated()));
        Request request = workspace.getRequest();
        if (request != null) {
            fields.add(Fields.stringField((String)REQUEST_COL, (String)GSON.toJson((Object)request)));
        }
        if ((data = workspace.getData()) != null) {
            fields.add(Fields.bytesField((String)DATA_COL, (byte[])data));
        }
        return fields;
    }

    @Nullable
    private Workspace readWorkspace(NamespacedId id) throws IOException {
        Optional row = this.table.read(this.getKey(id));
        return row.map(this::readWorkspace).orElse(null);
    }

    private Workspace readWorkspace(StructuredRow row) {
        Namespace namespace = new Namespace(row.getString(NAMESPACE_COL), row.getLong(GENERATION_COL).longValue());
        NamespacedId id = new NamespacedId(namespace, row.getString(ID_COL));
        String propertiesStr = row.getString(PROPERTIES_COL);
        Map properties = propertiesStr == null || propertiesStr.isEmpty() ? Collections.emptyMap() : (Map)GSON.fromJson(propertiesStr, MAP_TYPE);
        String requestStr = row.getString(REQUEST_COL);
        Request request = requestStr == null || requestStr.isEmpty() ? null : (Request)GSON.fromJson(requestStr, Request.class);
        return ((Workspace.Builder)((Workspace.Builder)((Workspace.Builder)Workspace.builder(id, row.getString(NAME_COL)).setCreated(row.getLong(CREATED_COL)).setUpdated(row.getLong(UPDATED_COL)).setData(row.getBytes(DATA_COL)).setRequest(request).setScope(row.getString(SCOPE_COL))).setType(DataType.valueOf(row.getString(TYPE_COL)))).setProperties(properties)).build();
    }

    private List<Field<?>> getKey(NamespacedId id) {
        ArrayList keyFields = new ArrayList();
        keyFields.add(Fields.stringField((String)NAMESPACE_COL, (String)id.getNamespace().getName()));
        keyFields.add(Fields.longField((String)GENERATION_COL, (Long)id.getNamespace().getGeneration()));
        keyFields.add(Fields.stringField((String)ID_COL, (String)id.getId()));
        return keyFields;
    }
}

