/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.workspace;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.cdap.wrangler.proto.Recipe;
import io.cdap.wrangler.proto.Request;
import io.cdap.wrangler.proto.RequestV1;
import io.cdap.wrangler.proto.Sampling;
import io.cdap.wrangler.proto.Workspace;
import java.lang.reflect.Type;

public class RequestDeserializer
implements JsonDeserializer<Request> {
    public Request deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        if (!object.has("version")) {
            throw new JsonParseException(String.format("Version field is not specified in the request.", new Object[0]));
        }
        int version = object.get("version").getAsInt();
        if (version == 1) {
            Workspace workspace = (Workspace)context.deserialize(object.get("workspace"), Workspace.class);
            Recipe recipe = (Recipe)context.deserialize(object.get("recipe"), Recipe.class);
            Sampling sampling = (Sampling)context.deserialize(object.get("sampling"), Sampling.class);
            JsonObject properties = (JsonObject)context.deserialize(object.get("properties"), JsonObject.class);
            return new RequestV1(workspace, recipe, sampling, properties);
        }
        throw new JsonParseException(String.format("Unsupported request version %d.", version));
    }
}

