/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.workspace;

import com.google.gson.Gson;
import io.cdap.cdap.spi.data.StructuredTable;
import io.cdap.cdap.spi.data.StructuredTableContext;
import io.cdap.cdap.spi.data.TableNotFoundException;
import io.cdap.cdap.spi.data.table.StructuredTableId;
import io.cdap.cdap.spi.data.table.StructuredTableSpecification;
import io.cdap.cdap.spi.data.table.field.Field;
import io.cdap.cdap.spi.data.table.field.FieldType;
import io.cdap.cdap.spi.data.table.field.Fields;
import io.cdap.wrangler.api.DirectiveConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;

public class ConfigStore {
    private static final Gson GSON = new Gson();
    private static final String KEY_COL = "key";
    private static final String VAL_COL = "value";
    private static final Field<String> keyField = Fields.stringField((String)"key", (String)"directives");
    public static final StructuredTableId TABLE_ID = new StructuredTableId("dataprep_config");
    public static final StructuredTableSpecification TABLE_SPEC = new StructuredTableSpecification.Builder().withId(TABLE_ID).withFields(new FieldType[]{new FieldType("key", FieldType.Type.STRING), new FieldType("value", FieldType.Type.STRING)}).withPrimaryKeys(new String[]{"key"}).build();
    private final StructuredTable table;

    public ConfigStore(StructuredTable table) {
        this.table = table;
    }

    public static ConfigStore get(StructuredTableContext context) {
        try {
            StructuredTable table = context.getTable(TABLE_ID);
            return new ConfigStore(table);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(String.format("System table '%s' does not exist. Please check your system environment.", TABLE_ID.getName()), e);
        }
    }

    public void updateConfig(DirectiveConfig config) throws IOException {
        ArrayList<Object> fields = new ArrayList<Object>(2);
        fields.add(keyField);
        fields.add(Fields.stringField((String)VAL_COL, (String)GSON.toJson((Object)config)));
        this.table.upsert(fields);
    }

    public DirectiveConfig getConfig() throws IOException {
        Optional row = this.table.read(Collections.singletonList(keyField));
        String configStr = row.map(r -> r.getString(VAL_COL)).orElse("{}");
        return (DirectiveConfig)GSON.fromJson(configStr, DirectiveConfig.class);
    }
}

