/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.schema;

import io.cdap.wrangler.dataset.schema.SchemaDescriptor;
import javax.annotation.Nullable;

public class SchemaRow {
    private final SchemaDescriptor descriptor;
    private final long created;
    private final long updated;
    private final long autoVersion;
    private final Long currentVersion;

    private SchemaRow(SchemaDescriptor descriptor, long created, long updated, long autoVersion, @Nullable Long currentVersion) {
        this.descriptor = descriptor;
        this.created = created;
        this.updated = updated;
        this.autoVersion = autoVersion;
        this.currentVersion = currentVersion;
    }

    public SchemaDescriptor getDescriptor() {
        return this.descriptor;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getAutoVersion() {
        return this.autoVersion;
    }

    @Nullable
    public Long getCurrentVersion() {
        return this.currentVersion;
    }

    static Builder builder(SchemaRow existing) {
        return new Builder(existing.getDescriptor()).setUpdated(existing.getUpdated()).setAutoVersion(existing.getAutoVersion()).setCurrentVersion(existing.getCurrentVersion());
    }

    static Builder builder(SchemaDescriptor descriptor) {
        return new Builder(descriptor);
    }

    public static class Builder {
        private final SchemaDescriptor descriptor;
        private long created;
        private long updated;
        private long autoVersion;
        private Long currentVersion;

        public Builder(SchemaDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public Builder setCreated(long created) {
            this.created = created;
            return this;
        }

        public Builder setUpdated(long updated) {
            this.updated = updated;
            return this;
        }

        public Builder setAutoVersion(long autoVersion) {
            this.autoVersion = autoVersion;
            return this;
        }

        public Builder setCurrentVersion(Long currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public SchemaRow build() {
            return new SchemaRow(this.descriptor, this.created, this.updated, this.autoVersion, this.currentVersion);
        }
    }
}

