/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.connections;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import io.cdap.cdap.api.Predicate;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.dataset.lib.CloseableIterator;
import io.cdap.cdap.internal.io.SchemaTypeAdapter;
import io.cdap.cdap.spi.data.StructuredRow;
import io.cdap.cdap.spi.data.StructuredTable;
import io.cdap.cdap.spi.data.StructuredTableContext;
import io.cdap.cdap.spi.data.TableNotFoundException;
import io.cdap.cdap.spi.data.table.StructuredTableId;
import io.cdap.cdap.spi.data.table.StructuredTableSpecification;
import io.cdap.cdap.spi.data.table.field.Field;
import io.cdap.cdap.spi.data.table.field.FieldType;
import io.cdap.cdap.spi.data.table.field.Fields;
import io.cdap.cdap.spi.data.table.field.Range;
import io.cdap.wrangler.dataset.connections.ConnectionAlreadyExistsException;
import io.cdap.wrangler.dataset.connections.ConnectionNotFoundException;
import io.cdap.wrangler.proto.Namespace;
import io.cdap.wrangler.proto.NamespacedId;
import io.cdap.wrangler.proto.connection.Connection;
import io.cdap.wrangler.proto.connection.ConnectionMeta;
import io.cdap.wrangler.proto.connection.ConnectionType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ConnectionStore {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Schema.class, (Object)new SchemaTypeAdapter()).create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();
    private static final String NAMESPACE_COL = "namespace";
    private static final String GENERATION_COL = "generation";
    private static final String ID_COL = "id";
    private static final String TYPE_COL = "type";
    private static final String NAME_COL = "name";
    private static final String DESC_COL = "description";
    private static final String PROPERTIES_COL = "properties";
    private static final String CREATED_COL = "created";
    private static final String UPDATED_COL = "updated";
    private static final String PRECONFIGURED_COL = "preconfigured";
    private static final StructuredTableId TABLE_ID = new StructuredTableId("connections");
    public static final StructuredTableSpecification TABLE_SPEC = new StructuredTableSpecification.Builder().withId(TABLE_ID).withFields(new FieldType[]{new FieldType("namespace", FieldType.Type.STRING), new FieldType("generation", FieldType.Type.LONG), new FieldType("id", FieldType.Type.STRING), new FieldType("type", FieldType.Type.STRING), new FieldType("name", FieldType.Type.STRING), new FieldType("description", FieldType.Type.STRING), new FieldType("properties", FieldType.Type.STRING), new FieldType("created", FieldType.Type.LONG), new FieldType("updated", FieldType.Type.LONG), new FieldType("preconfigured", FieldType.Type.STRING)}).withPrimaryKeys(new String[]{"namespace", "generation", "id"}).build();
    private final StructuredTable table;

    private ConnectionStore(StructuredTable table) {
        this.table = table;
    }

    public static ConnectionStore get(StructuredTableContext context) {
        try {
            StructuredTable table = context.getTable(TABLE_ID);
            return new ConnectionStore(table);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(String.format("System table '%s' does not exist. Please check your system environment.", TABLE_ID.getName()), e);
        }
    }

    public NamespacedId create(Namespace namespace, ConnectionMeta meta) throws ConnectionAlreadyExistsException, IOException {
        return this.create(namespace, meta, false);
    }

    public NamespacedId create(Namespace namespace, ConnectionMeta meta, boolean preconfigured) throws ConnectionAlreadyExistsException, IOException {
        NamespacedId id = new NamespacedId(namespace, ConnectionStore.getConnectionId(meta.getName()));
        Connection existing = this.read(id);
        if (existing != null) {
            throw new ConnectionAlreadyExistsException(String.format("Connection named '%s' with id '%s' already exists.", meta.getName(), id.getId()));
        }
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        Connection connection = Connection.builder((NamespacedId)id, (ConnectionMeta)meta).setCreated(now).setUpdated(now).setPreconfigured(preconfigured).build();
        this.table.upsert(this.toFields(connection, namespace.getGeneration()));
        return id;
    }

    public Connection get(NamespacedId id) throws ConnectionNotFoundException, IOException {
        Connection existing = this.read(id);
        if (existing == null) {
            throw new ConnectionNotFoundException(String.format("Connection '%s' does not exist", id.getId()));
        }
        return existing;
    }

    public void update(NamespacedId id, ConnectionMeta meta) throws ConnectionNotFoundException, IOException {
        Connection existing = this.get(id);
        Connection updated = Connection.builder((NamespacedId)id, (ConnectionMeta)meta).setCreated(existing.getCreated()).setUpdated(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
        this.table.upsert(this.toFields(updated, id.getNamespace().getGeneration()));
    }

    public void delete(NamespacedId id) throws IOException {
        this.table.delete(this.getKey(id));
    }

    public boolean connectionExists(Namespace namespace, String connectionName) throws IOException {
        return this.read(new NamespacedId(namespace, ConnectionStore.getConnectionId(connectionName))) != null;
    }

    public List<Connection> list(Namespace namespace, Predicate<Connection> filter) throws IOException {
        ArrayList<Field> key = new ArrayList<Field>(2);
        key.add(Fields.stringField((String)NAMESPACE_COL, (String)namespace.getName()));
        key.add(Fields.longField((String)GENERATION_COL, (Long)namespace.getGeneration()));
        Range range = Range.singleton(key);
        try (CloseableIterator rowIter = this.table.scan(range, Integer.MAX_VALUE);){
            ArrayList<Connection> result = new ArrayList<Connection>();
            while (rowIter.hasNext()) {
                StructuredRow row = (StructuredRow)rowIter.next();
                Connection connection = this.fromRow(row);
                if (!filter.apply((Object)connection)) continue;
                result.add(connection);
            }
            ArrayList<Connection> arrayList = result;
            return arrayList;
        }
    }

    public static String getConnectionId(String name) {
        name = name.trim();
        name = name.toLowerCase();
        name = name.replaceAll("[^a-zA-Z0-9_]", "_");
        return name;
    }

    @Nullable
    private Connection read(NamespacedId id) throws IOException {
        Optional row = this.table.read(this.getKey(id));
        return row.map(this::fromRow).orElse(null);
    }

    private List<Field<?>> getKey(NamespacedId id) {
        ArrayList keyFields = new ArrayList(2);
        keyFields.add(Fields.stringField((String)NAMESPACE_COL, (String)id.getNamespace().getName()));
        keyFields.add(Fields.longField((String)GENERATION_COL, (Long)id.getNamespace().getGeneration()));
        keyFields.add(Fields.stringField((String)ID_COL, (String)id.getId()));
        return keyFields;
    }

    private List<Field<?>> toFields(Connection connection, long generation) {
        ArrayList fields = new ArrayList(8);
        fields.add(Fields.stringField((String)NAMESPACE_COL, (String)connection.getNamespace()));
        fields.add(Fields.longField((String)GENERATION_COL, (Long)generation));
        fields.add(Fields.stringField((String)ID_COL, (String)connection.getId()));
        fields.add(Fields.stringField((String)TYPE_COL, (String)connection.getType().name()));
        fields.add(Fields.stringField((String)NAME_COL, (String)connection.getName()));
        fields.add(Fields.stringField((String)DESC_COL, (String)connection.getDescription()));
        fields.add(Fields.stringField((String)PROPERTIES_COL, (String)GSON.toJson((Object)connection.getProperties())));
        fields.add(Fields.longField((String)CREATED_COL, (Long)connection.getCreated()));
        fields.add(Fields.longField((String)UPDATED_COL, (Long)connection.getUpdated()));
        fields.add(Fields.stringField((String)PRECONFIGURED_COL, (String)String.valueOf(connection.isPreconfigured())));
        return fields;
    }

    private Connection fromRow(StructuredRow row) {
        Namespace namespace = new Namespace(row.getString(NAMESPACE_COL), row.getLong(GENERATION_COL).longValue());
        return ((Connection.Builder)((Connection.Builder)((Connection.Builder)((Connection.Builder)Connection.builder((NamespacedId)new NamespacedId(namespace, row.getString(ID_COL))).setType(ConnectionType.valueOf((String)row.getString(TYPE_COL)))).setName(row.getString(NAME_COL))).setDescription(row.getString(DESC_COL))).setProperties((Map)GSON.fromJson(row.getString(PROPERTIES_COL), MAP_TYPE))).setCreated(row.getLong(CREATED_COL).longValue()).setUpdated(row.getLong(UPDATED_COL).longValue()).setPreconfigured(Boolean.valueOf(row.getString(PRECONFIGURED_COL)).booleanValue()).build();
    }
}

