/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.workspace;

import io.cdap.wrangler.dataset.workspace.DataType;
import io.cdap.wrangler.dataset.workspace.WorkspaceMeta;
import io.cdap.wrangler.proto.NamespacedId;
import io.cdap.wrangler.proto.Request;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Workspace
extends WorkspaceMeta {
    private final NamespacedId id;
    private final long created;
    private final long updated;
    private final byte[] data;
    private final Request request;

    private Workspace(NamespacedId id, String name, String scope, DataType type, Map<String, String> properties, long created, long updated, @Nullable byte[] data, @Nullable Request request) {
        super(name, scope, type, properties);
        this.id = id;
        this.created = created;
        this.updated = updated;
        this.data = data == null ? null : Arrays.copyOf(data, data.length);
        this.request = request;
    }

    public NamespacedId getNamespacedId() {
        return this.id;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    @Nullable
    public byte[] getData() {
        return this.data;
    }

    @Nullable
    public Request getRequest() {
        return this.request;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return this.created == workspace.created && this.updated == workspace.updated && Objects.equals(this.id, workspace.id) && Arrays.equals(this.data, workspace.data) && Objects.equals(this.request, workspace.request);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.id, this.created, this.updated, this.request);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public static Builder builder(NamespacedId id, String name) {
        return new Builder(id, name);
    }

    public static Builder builder(Workspace existing) {
        return ((Builder)((Builder)((Builder)new Builder(existing.getNamespacedId(), existing.getName()).setType(existing.getType())).setScope(existing.getScope())).setCreated(existing.getCreated()).setUpdated(existing.getUpdated()).setProperties(existing.getProperties())).setData(existing.getData()).setRequest(existing.getRequest());
    }

    public static class Builder
    extends WorkspaceMeta.Builder<Builder> {
        private final NamespacedId id;
        private long created;
        private long updated;
        private byte[] data;
        private Request request;

        Builder(NamespacedId id, String name) {
            super(name);
            this.id = id;
        }

        public Builder setCreated(long created) {
            this.created = created;
            return this;
        }

        public Builder setUpdated(long updated) {
            this.updated = updated;
            return this;
        }

        public Builder setData(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder setRequest(Request request) {
            this.request = request;
            return this;
        }

        @Override
        public Workspace build() {
            return new Workspace(this.id, this.name, this.scope, this.type, this.properties, this.created, this.updated, this.data, this.request);
        }
    }
}

