/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dataset.schema;

import io.cdap.cdap.api.dataset.lib.CloseableIterator;
import io.cdap.cdap.spi.data.StructuredRow;
import io.cdap.cdap.spi.data.StructuredTable;
import io.cdap.cdap.spi.data.StructuredTableContext;
import io.cdap.cdap.spi.data.TableNotFoundException;
import io.cdap.cdap.spi.data.table.StructuredTableId;
import io.cdap.cdap.spi.data.table.StructuredTableSpecification;
import io.cdap.cdap.spi.data.table.field.Field;
import io.cdap.cdap.spi.data.table.field.FieldType;
import io.cdap.cdap.spi.data.table.field.Fields;
import io.cdap.cdap.spi.data.table.field.Range;
import io.cdap.wrangler.dataset.schema.SchemaDescriptor;
import io.cdap.wrangler.dataset.schema.SchemaNotFoundException;
import io.cdap.wrangler.dataset.schema.SchemaRow;
import io.cdap.wrangler.proto.Namespace;
import io.cdap.wrangler.proto.NamespacedId;
import io.cdap.wrangler.proto.schema.SchemaDescriptorType;
import io.cdap.wrangler.proto.schema.SchemaEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class SchemaRegistry {
    private static final String NAMESPACE_COL = "namespace";
    private static final String GENERATION_COL = "generation";
    private static final String ID_COL = "id";
    private final StructuredTable metaTable;
    private final StructuredTable entryTable;
    private static final StructuredTableId META_TABLE_ID = new StructuredTableId("schema_registry_meta");
    private static final StructuredTableId ENTRY_TABLE_ID = new StructuredTableId("schema_registry_entries");
    public static final StructuredTableSpecification META_TABLE_SPEC = new StructuredTableSpecification.Builder().withId(META_TABLE_ID).withFields(new FieldType[]{new FieldType("namespace", FieldType.Type.STRING), new FieldType("generation", FieldType.Type.LONG), new FieldType("id", FieldType.Type.STRING), new FieldType("name", FieldType.Type.STRING), new FieldType("description", FieldType.Type.STRING), new FieldType("created", FieldType.Type.LONG), new FieldType("updated", FieldType.Type.LONG), new FieldType("type", FieldType.Type.STRING), new FieldType("auto", FieldType.Type.LONG), new FieldType("current", FieldType.Type.LONG)}).withPrimaryKeys(new String[]{"namespace", "generation", "id"}).build();
    public static final StructuredTableSpecification ENTRY_TABLE_SPEC = new StructuredTableSpecification.Builder().withId(ENTRY_TABLE_ID).withFields(new FieldType[]{new FieldType("namespace", FieldType.Type.STRING), new FieldType("generation", FieldType.Type.LONG), new FieldType("id", FieldType.Type.STRING), new FieldType("version", FieldType.Type.LONG), new FieldType("schema", FieldType.Type.BYTES)}).withPrimaryKeys(new String[]{"namespace", "generation", "id", "version"}).build();

    public SchemaRegistry(StructuredTable metaTable, StructuredTable entryTable) {
        this.metaTable = metaTable;
        this.entryTable = entryTable;
    }

    public static SchemaRegistry get(StructuredTableContext context) {
        try {
            StructuredTable metaTable = context.getTable(META_TABLE_ID);
            StructuredTable entryTable = context.getTable(ENTRY_TABLE_ID);
            return new SchemaRegistry(metaTable, entryTable);
        }
        catch (TableNotFoundException e) {
            throw new IllegalStateException(String.format("System table '%s' does not exist. Please check your system environment.", e.getId().getName()), e);
        }
    }

    public void write(SchemaDescriptor schemaDescriptor) throws IOException {
        SchemaRow.Builder builder = SchemaRow.builder(schemaDescriptor);
        long now = System.currentTimeMillis() / 1000L;
        SchemaRow existing = this.getSchemaRow(schemaDescriptor.getId());
        if (existing == null) {
            builder.setCreated(now).setUpdated(now).setAutoVersion(0L);
        } else {
            builder.setCreated(existing.getCreated()).setUpdated(now).setAutoVersion(existing.getAutoVersion()).setCurrentVersion(existing.getCurrentVersion());
        }
        this.metaTable.upsert(this.toFields(builder.build()));
    }

    public void delete(NamespacedId id) throws IOException {
        this.metaTable.delete(this.getMetaKey(id));
        Range range = Range.singleton(this.getMetaKey(id));
        try (CloseableIterator rowIter = this.entryTable.scan(range, Integer.MAX_VALUE);){
            while (rowIter.hasNext()) {
                StructuredRow row = (StructuredRow)rowIter.next();
                Namespace namespace = new Namespace(row.getString(NAMESPACE_COL), row.getLong(GENERATION_COL).longValue());
                NamespacedId entryId = new NamespacedId(namespace, row.getString(ID_COL));
                long entryVersion = row.getLong("version");
                this.entryTable.delete(this.getEntryKey(entryId, entryVersion));
            }
        }
    }

    public long add(NamespacedId id, byte[] specification) throws IOException {
        SchemaRow existing = this.getSchemaRow(id);
        if (existing == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist.", id.getId()));
        }
        long version = existing.getAutoVersion() + 1L;
        SchemaRow updated = SchemaRow.builder(existing).setUpdated(System.currentTimeMillis() / 1000L).setAutoVersion(version).setCurrentVersion(version).build();
        this.metaTable.upsert(this.toFields(updated));
        List<Field<?>> fields = this.getEntryKey(id, version);
        fields.add(Fields.bytesField((String)"schema", (byte[])specification));
        this.entryTable.upsert(fields);
        return version;
    }

    public void remove(NamespacedId id, long version) throws IOException {
        SchemaRow row = this.getSchemaRow(id);
        if (row == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist.", id.getId()));
        }
        this.entryTable.delete(this.getEntryKey(id, version));
    }

    public boolean hasSchema(NamespacedId id, long version) throws IOException {
        SchemaRow schemaRow = this.getSchemaRow(id);
        if (schemaRow == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist", id.getId()));
        }
        Optional row = this.entryTable.read(this.getEntryKey(id, version));
        return row.isPresent();
    }

    public boolean hasSchema(NamespacedId id) throws IOException {
        Optional row = this.metaTable.read(this.getMetaKey(id));
        return row.isPresent();
    }

    public Set<Long> getVersions(NamespacedId id) throws IOException {
        if (this.getSchemaRow(id) == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist.", id.getId()));
        }
        Range range = Range.singleton(this.getMetaKey(id));
        try (CloseableIterator rowIter = this.entryTable.scan(range, Integer.MAX_VALUE);){
            LinkedHashSet<Long> versionSet = new LinkedHashSet<Long>();
            while (rowIter.hasNext()) {
                StructuredRow row = (StructuredRow)rowIter.next();
                versionSet.add(row.getLong("version"));
            }
            LinkedHashSet<Long> linkedHashSet = versionSet;
            return linkedHashSet;
        }
    }

    public SchemaEntry getEntry(NamespacedId id, long version) throws IOException {
        SchemaRow schemaRow = this.getSchemaRow(id);
        if (schemaRow == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist.", id.getId()));
        }
        return this.getEntry(schemaRow, version);
    }

    public SchemaEntry getEntry(NamespacedId id) throws IOException {
        SchemaRow schemaRow = this.getSchemaRow(id);
        if (schemaRow == null) {
            throw new SchemaNotFoundException(String.format("Schema '%s' does not exist.", id.getId()));
        }
        Long version = schemaRow.getCurrentVersion();
        if (version == null) {
            return new SchemaEntry(id, schemaRow.getDescriptor().getName(), schemaRow.getDescriptor().getDescription(), schemaRow.getDescriptor().getType(), Collections.emptySet(), null, null);
        }
        return this.getEntry(schemaRow, (long)version);
    }

    private SchemaEntry getEntry(SchemaRow schemaRow, long version) throws IOException {
        NamespacedId id = schemaRow.getDescriptor().getId();
        Optional row = this.entryTable.read(this.getEntryKey(id, version));
        if (!row.isPresent()) {
            throw new SchemaNotFoundException(String.format("Schema '%s' version '%d' does not exist.", id.getId(), version));
        }
        byte[] specification = ((StructuredRow)row.get()).getBytes("schema");
        Set<Long> versions = this.getVersions(id);
        return new SchemaEntry(id, schemaRow.getDescriptor().getName(), schemaRow.getDescriptor().getDescription(), schemaRow.getDescriptor().getType(), versions, specification, schemaRow.getCurrentVersion());
    }

    @Nullable
    private SchemaRow getSchemaRow(NamespacedId id) throws IOException {
        Optional row = this.metaTable.read(this.getMetaKey(id));
        return row.map(this::fromRow).orElse(null);
    }

    private List<Field<?>> getMetaKey(NamespacedId id) {
        ArrayList fields = new ArrayList(2);
        fields.add(Fields.stringField((String)NAMESPACE_COL, (String)id.getNamespace().getName()));
        fields.add(Fields.longField((String)GENERATION_COL, (Long)id.getNamespace().getGeneration()));
        fields.add(Fields.stringField((String)ID_COL, (String)id.getId()));
        return fields;
    }

    private List<Field<?>> getEntryKey(NamespacedId schemaId, long version) {
        ArrayList fields = new ArrayList(3);
        fields.add(Fields.stringField((String)NAMESPACE_COL, (String)schemaId.getNamespace().getName()));
        fields.add(Fields.longField((String)GENERATION_COL, (Long)schemaId.getNamespace().getGeneration()));
        fields.add(Fields.stringField((String)ID_COL, (String)schemaId.getId()));
        fields.add(Fields.longField((String)"version", (Long)version));
        return fields;
    }

    private List<Field<?>> toFields(SchemaRow schemaRow) {
        ArrayList fields = new ArrayList(9);
        fields.add(Fields.stringField((String)NAMESPACE_COL, (String)schemaRow.getDescriptor().getId().getNamespace().getName()));
        fields.add(Fields.longField((String)GENERATION_COL, (Long)schemaRow.getDescriptor().getId().getNamespace().getGeneration()));
        fields.add(Fields.stringField((String)ID_COL, (String)schemaRow.getDescriptor().getId().getId()));
        fields.add(Fields.stringField((String)"name", (String)schemaRow.getDescriptor().getName()));
        fields.add(Fields.stringField((String)"description", (String)schemaRow.getDescriptor().getDescription()));
        fields.add(Fields.stringField((String)"type", (String)schemaRow.getDescriptor().getType().name()));
        fields.add(Fields.longField((String)"created", (Long)schemaRow.getCreated()));
        fields.add(Fields.longField((String)"updated", (Long)schemaRow.getUpdated()));
        fields.add(Fields.longField((String)"auto", (Long)schemaRow.getAutoVersion()));
        if (schemaRow.getCurrentVersion() != null) {
            fields.add(Fields.longField((String)"current", (Long)schemaRow.getCurrentVersion()));
        }
        return fields;
    }

    private SchemaRow fromRow(StructuredRow row) {
        Namespace namespace = new Namespace(row.getString(NAMESPACE_COL), row.getLong(GENERATION_COL).longValue());
        NamespacedId id = new NamespacedId(namespace, row.getString(ID_COL));
        SchemaDescriptor descriptor = new SchemaDescriptor(id, row.getString("name"), row.getString("description"), SchemaDescriptorType.valueOf((String)row.getString("type")));
        return SchemaRow.builder(descriptor).setCreated(row.getLong("created")).setUpdated(row.getLong("updated")).setAutoVersion(row.getLong("auto")).setCurrentVersion(row.getLong("current")).build();
    }

    private static class EntryColumn {
        private static final String VERSION = "version";
        private static final String SCHEMA = "schema";

        private EntryColumn() {
        }
    }

    private static class MetaColumn {
        private static final String NAME = "name";
        private static final String DESC = "description";
        private static final String CREATED = "created";
        private static final String UPDATED = "updated";
        private static final String TYPE = "type";
        private static final String AUTO_VERSION = "auto";
        private static final String CURRENT_VERSION = "current";

        private MetaColumn() {
        }
    }
}

