/*
 * Copyright © 2019 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package io.cdap.wrangler.dataset.connections;

import io.cdap.wrangler.proto.NotFoundException;

/**
 * Thrown when a connection does not exist when one is expected to exist.
 */
public class ConnectionNotFoundException extends NotFoundException {

  public ConnectionNotFoundException(String message) {
    super(message);
  }
}
