/*
 * Copyright © 2017-2019 Cask Data, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package io.cdap.wrangler.service.explorer;

import io.cdap.cdap.api.dataset.Dataset;

/**
 * This class implements the provider pattern for providing dataset at runtime.
 *
 * @param <T> type of dataset provided
 */
public interface DatasetProvider<T extends Dataset> {
  T acquire() throws Exception;
  void release(T dataset);
}
