/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.re;

import io.cdap.re.Rule;
import io.cdap.re.Rulebook;
import io.cdap.re.parser.RulebookBaseVisitor;
import io.cdap.re.parser.RulebookParser;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;

public class RulebookASTVisitor
extends RulebookBaseVisitor<Rulebook.Builder> {
    private Rulebook.Builder rbBuilder;
    private Rule.Builder ruleBuilder;

    public Rulebook get() {
        return this.rbBuilder.build();
    }

    private String trimQuote(String value) {
        return value.substring(1, value.length() - 1);
    }

    @Override
    public Rulebook.Builder visitRulebook(RulebookParser.RulebookContext ctx) {
        this.rbBuilder = new Rulebook.Builder(ctx.Identifier().toString());
        return (Rulebook.Builder)super.visitRulebook(ctx);
    }

    @Override
    public Rulebook.Builder visitRbVersion(RulebookParser.RbVersionContext ctx) {
        this.rbBuilder.version(Long.parseLong(ctx.Number().getText()));
        return (Rulebook.Builder)super.visitRbVersion(ctx);
    }

    @Override
    public Rulebook.Builder visitRbMetaDescription(RulebookParser.RbMetaDescriptionContext ctx) {
        this.rbBuilder.description(this.trimQuote(ctx.String().getText()));
        return (Rulebook.Builder)super.visitRbMetaDescription(ctx);
    }

    @Override
    public Rulebook.Builder visitRbMetaCreatedDate(RulebookParser.RbMetaCreatedDateContext ctx) {
        this.rbBuilder.created(Long.parseLong(ctx.Number().getText()));
        return (Rulebook.Builder)super.visitRbMetaCreatedDate(ctx);
    }

    @Override
    public Rulebook.Builder visitRbMetaUpdatedDate(RulebookParser.RbMetaUpdatedDateContext ctx) {
        this.rbBuilder.updated(Long.parseLong(ctx.Number().getText()));
        return (Rulebook.Builder)super.visitRbMetaUpdatedDate(ctx);
    }

    @Override
    public Rulebook.Builder visitRbMetaUserName(RulebookParser.RbMetaUserNameContext ctx) {
        this.rbBuilder.user(this.trimQuote(ctx.String().getText()));
        return (Rulebook.Builder)super.visitRbMetaUserName(ctx);
    }

    @Override
    public Rulebook.Builder visitRbMetaSourceName(RulebookParser.RbMetaSourceNameContext ctx) {
        this.rbBuilder.source(this.trimQuote(ctx.String().getText()));
        return (Rulebook.Builder)super.visitRbMetaSourceName(ctx);
    }

    @Override
    public Rulebook.Builder visitRbRule(RulebookParser.RbRuleContext ctx) {
        this.ruleBuilder = new Rule.Builder(ctx.Identifier().toString());
        super.visitRbRule(ctx);
        this.rbBuilder.addRule(this.ruleBuilder.build());
        return this.rbBuilder;
    }

    @Override
    public Rulebook.Builder visitDescriptionClause(RulebookParser.DescriptionClauseContext ctx) {
        this.ruleBuilder.description(this.trimQuote(ctx.String().getText()));
        return (Rulebook.Builder)super.visitDescriptionClause(ctx);
    }

    @Override
    public Rulebook.Builder visitAssignments(RulebookParser.AssignmentsContext ctx) {
        return (Rulebook.Builder)super.visitAssignments(ctx);
    }

    @Override
    public Rulebook.Builder visitAssignment(RulebookParser.AssignmentContext ctx) {
        int childCount = ctx.getChildCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < childCount - 1; ++i) {
            ParseTree child = ctx.getChild(i);
            sb.append(StringUtils.trim((String)child.getText())).append(" ");
        }
        this.ruleBuilder.given(sb.toString());
        return (Rulebook.Builder)super.visitAssignment(ctx);
    }

    @Override
    public Rulebook.Builder visitAction(RulebookParser.ActionContext ctx) {
        int childCount = ctx.getChildCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childCount; ++i) {
            ParseTree child = ctx.getChild(i);
            sb.append(StringUtils.trim((String)child.getText())).append(" ");
        }
        this.ruleBuilder.then(sb.toString());
        return (Rulebook.Builder)super.visitAction(ctx);
    }

    @Override
    public Rulebook.Builder visitCondition(RulebookParser.ConditionContext ctx) {
        int childCount = ctx.getChildCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childCount; ++i) {
            ParseTree child = ctx.getChild(i);
            sb.append(StringUtils.trim((String)child.getText()));
        }
        this.ruleBuilder.when(sb.toString());
        return (Rulebook.Builder)super.visitCondition(ctx);
    }
}

