/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.spec;

import io.cdap.mmds.spec.Param;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Range;
import java.util.Map;

public class IntParam
extends Param<Integer> {
    private final ParamSpec spec;

    public IntParam(String name, String label, String description, int defaultVal, Range range, Map<String, String> params) {
        super(name, description, defaultVal, params);
        this.spec = new ParamSpec("int", name, label, description, String.valueOf(defaultVal), null, range);
    }

    @Override
    protected Integer parseVal(String strVal) {
        try {
            return Integer.parseInt(strVal);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Invalid modeler parameter %s=%s. Must be a valid integer.", this.name, strVal));
        }
    }

    @Override
    public ParamSpec getSpec() {
        return this.spec;
    }
}

