/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.splitter.param;

import io.cdap.mmds.spec.IntParam;
import io.cdap.mmds.spec.LongParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Parameters;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class RandomParams
implements Parameters {
    private final IntParam testPercentage;
    private final LongParam seed;

    public RandomParams(Map<String, String> properties) {
        this.testPercentage = new IntParam("testPercentage", "Test Percentage", "Percent of data that should be used for testing. Must be a whole number and greater than 0 but less than 100.", 20, new Range(1, 100, true, false), properties);
        this.seed = new LongParam("seed", "Seed", "Seed to use for random splitting of data. The same seed, same test percentage, and same data will produce the same splits.", null, null, properties);
    }

    public double[] getWeights() {
        return new double[]{100 - (Integer)this.testPercentage.getVal(), ((Integer)this.testPercentage.getVal()).intValue()};
    }

    @Nullable
    public Long getSeed() {
        return (Long)this.seed.getVal();
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        return Params.putParams(map, this.testPercentage, this.seed);
    }

    @Override
    public List<ParamSpec> getSpec() {
        ArrayList<ParamSpec> spec = new ArrayList<ParamSpec>();
        return Params.addParams(spec, this.testPercentage, this.seed);
    }
}

