/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds;

import java.util.function.BinaryOperator;

public final class NullableMath {
    private NullableMath() {
    }

    public static Double min(Double x, Double y) {
        return NullableMath.apply(x, y, Math::min);
    }

    public static Double max(Double x, Double y) {
        return NullableMath.apply(x, y, Math::max);
    }

    public static Double mean(Double mean1, long count1, Double mean2, long count2) {
        return NullableMath.apply(mean1, mean2, (m1, m2) -> (m1 * (double)count1 + m2 * (double)count2) / (double)(count1 + count2));
    }

    public static Double m2(Double firstM2, Double mean1, long count1, Double secondM2, Double mean2, long count2) {
        Double newMean = NullableMath.mean(mean1, count1, mean2, count2);
        return NullableMath.apply(firstM2, secondM2, (m21, m22) -> m21 + m22 + (double)count1 * NullableMath.square(mean1 - newMean) + (double)count2 * NullableMath.square(mean2 - newMean));
    }

    public static Double stddev(Double firstM2, Double mean1, long count1, Double secondM2, Double mean2, long count2) {
        return Math.sqrt(NullableMath.m2(firstM2, mean1, count1, secondM2, mean2, count2) / (double)(count1 + count2));
    }

    public static Double square(Double x) {
        if (x == null) {
            return x;
        }
        return x * x;
    }

    public static <T> T apply(T x, T y, BinaryOperator<T> func) {
        if (x != null && y != null) {
            return (T)func.apply(x, y);
        }
        if (x != null) {
            return x;
        }
        return y;
    }
}

