/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.feature;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataTypes;

public abstract class FeatureGenerator {
    protected final List<String> features;
    private final Set<String> categoricalFeatures;
    private PipelineModel featureGenModel;

    protected FeatureGenerator(List<String> features, Set<String> categoricalFeatures) {
        this.features = new ArrayList<String>(features);
        this.categoricalFeatures = new HashSet<String>(categoricalFeatures);
    }

    public List<String> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    public Dataset<Row> generateFeatures(Dataset<Row> rawData, String target) {
        return this.generateFeatures(rawData, (List<String>)ImmutableList.of((Object)target));
    }

    public Dataset<Row> generateFeatures(Dataset<Row> rawData, List<String> extraColumns) {
        int numFeatures = this.features.size();
        Column[] columnsWithCopies = new Column[2 * numFeatures + extraColumns.size()];
        int i = 0;
        HashMap<String, Object> nullValueMap = new HashMap<String, Object>();
        for (String originalFeature : this.features) {
            String cleanName = this.cleanName(originalFeature);
            columnsWithCopies[i] = new Column(originalFeature);
            Column featureCopy = new Column(originalFeature).as(cleanName);
            if (this.isCategorical(originalFeature)) {
                featureCopy = featureCopy.cast(DataTypes.StringType);
                nullValueMap.put(cleanName, "?");
            } else {
                featureCopy = featureCopy.cast(DataTypes.DoubleType);
                nullValueMap.put(cleanName, -1.0);
            }
            columnsWithCopies[numFeatures + i] = featureCopy;
            ++i;
        }
        i = 2 * numFeatures;
        for (String extraColumn : extraColumns) {
            columnsWithCopies[i] = new Column(extraColumn);
            ++i;
        }
        Dataset cleanData = rawData.select(columnsWithCopies).na().fill(nullValueMap);
        if (this.featureGenModel == null) {
            this.featureGenModel = this.getFeatureGenModel((Dataset<Row>)cleanData);
        }
        return this.featureGenModel.transform(cleanData);
    }

    @Nullable
    public PipelineModel getFeatureGenModel() {
        return this.featureGenModel;
    }

    protected abstract PipelineModel getFeatureGenModel(Dataset<Row> var1);

    protected boolean isCategorical(String featureName) {
        return this.categoricalFeatures.contains(featureName);
    }

    protected String cleanName(String originalName) {
        return "_c_" + originalName;
    }

    protected String indexedName(String originalName) {
        return "_i_" + originalName;
    }
}

