/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.train;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.mmds.api.AlgorithmType;
import io.cdap.mmds.data.EvaluationMetrics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.feature.StringIndexerModel;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.sql.Dataset;

public class ModelOutput {
    private final PipelineModel featureGenModel;
    private final MLWritable model;
    private final EvaluationMetrics evaluationMetrics;
    private final List<String> featureNames;
    private final Set<String> categoricalFeatures;
    private final Dataset predictions;
    private final StringIndexerModel targetIndexModel;
    private final AlgorithmType algorithmType;
    private final Schema schema;

    private ModelOutput(PipelineModel featureGenModel, MLWritable model, EvaluationMetrics evaluationMetrics, List<String> featureNames, Set<String> categoricalFeatures, Dataset predictions, @Nullable StringIndexerModel targetIndexModel, AlgorithmType algorithmType, Schema schema) {
        this.featureGenModel = featureGenModel;
        this.model = model;
        this.evaluationMetrics = evaluationMetrics;
        this.featureNames = ImmutableList.copyOf(featureNames);
        this.categoricalFeatures = ImmutableSet.copyOf(categoricalFeatures);
        this.predictions = predictions;
        this.targetIndexModel = targetIndexModel;
        this.algorithmType = algorithmType;
        this.schema = schema;
    }

    public PipelineModel getFeatureGenModel() {
        return this.featureGenModel;
    }

    public MLWritable getModel() {
        return this.model;
    }

    public EvaluationMetrics getEvaluationMetrics() {
        return this.evaluationMetrics;
    }

    public List<String> getFeatureNames() {
        return this.featureNames;
    }

    public Set<String> getCategoricalFeatures() {
        return this.categoricalFeatures;
    }

    public Dataset getPredictions() {
        return this.predictions;
    }

    @Nullable
    public StringIndexerModel getTargetIndexModel() {
        return this.targetIndexModel;
    }

    public AlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private PipelineModel featureGenModel;
        private MLWritable model;
        private EvaluationMetrics evaluationMetrics;
        private List<String> featureNames = new ArrayList<String>();
        private Set<String> categoricalFeatures = new HashSet<String>();
        private StringIndexerModel targetIndexModel;
        private Dataset predictions;
        private AlgorithmType algorithmType;
        private Schema schema;

        public Builder setFeatureGenModel(PipelineModel featureGenModel) {
            this.featureGenModel = featureGenModel;
            return this;
        }

        public Builder setModel(MLWritable model) {
            this.model = model;
            return this;
        }

        public Builder setEvaluationMetrics(EvaluationMetrics evaluationMetrics) {
            this.evaluationMetrics = evaluationMetrics;
            return this;
        }

        public Builder setFeatureNames(List<String> featureNames) {
            this.featureNames.clear();
            this.featureNames.addAll(featureNames);
            return this;
        }

        public Builder setCategoricalFeatures(Set<String> categoricalFeatures) {
            this.categoricalFeatures.clear();
            this.categoricalFeatures.addAll(categoricalFeatures);
            return this;
        }

        public Builder setTargetIndexModel(StringIndexerModel targetIndexModel) {
            this.targetIndexModel = targetIndexModel;
            return this;
        }

        public Builder setPredictions(Dataset predictions) {
            this.predictions = predictions;
            return this;
        }

        public Builder setAlgorithmType(AlgorithmType algorithmType) {
            this.algorithmType = algorithmType;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public ModelOutput build() {
            if (this.featureGenModel == null) {
                throw new IllegalStateException("FeatureGen pipeline is not set.");
            }
            if (this.model == null) {
                throw new IllegalStateException("Model is not set.");
            }
            if (this.evaluationMetrics == null) {
                throw new IllegalStateException("Model evaluation metrics are not set.");
            }
            if (this.predictions == null) {
                throw new IllegalStateException("Test predictions not set.");
            }
            if (this.algorithmType == null) {
                throw new IllegalStateException("Algorithm type not set.");
            }
            if (this.schema == null) {
                throw new IllegalStateException("Schema not set.");
            }
            return new ModelOutput(this.featureGenModel, this.model, this.evaluationMetrics, this.featureNames, this.categoricalFeatures, this.predictions, this.targetIndexModel, this.algorithmType, this.schema);
        }
    }
}

