/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import io.cdap.cdap.api.data.schema.Schema;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Experiment {
    private static final Set<Schema.Type> VALID_TYPES = ImmutableSet.of((Object)Schema.Type.BOOLEAN, (Object)Schema.Type.STRING, (Object)Schema.Type.INT, (Object)Schema.Type.LONG, (Object)Schema.Type.FLOAT, (Object)Schema.Type.DOUBLE, (Object[])new Schema.Type[0]);
    private final String name;
    private final String description;
    private final String srcpath;
    private final String outcome;
    private final String outcomeType;
    private final List<String> directives;

    public Experiment(String name, Experiment experiment) {
        this(name, experiment.getDescription(), experiment.getSrcpath(), experiment.getOutcome(), experiment.getOutcomeType(), experiment.getDirectives());
    }

    public Experiment(String name, String description, String srcpath, String outcome, String outcomeType, List<String> directives) {
        this.name = name;
        this.description = description == null ? "" : description;
        this.srcpath = srcpath;
        this.outcome = outcome;
        this.outcomeType = outcomeType;
        this.directives = Collections.unmodifiableList(directives);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSrcpath() {
        return this.srcpath;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getOutcomeType() {
        return this.outcomeType;
    }

    public List<String> getDirectives() {
        return this.directives == null ? Collections.emptyList() : this.directives;
    }

    public void validate() {
        if (this.srcpath == null || this.srcpath.isEmpty()) {
            throw new IllegalArgumentException("Experiment srcpath must be provided.");
        }
        if (this.outcome == null || this.outcome.isEmpty()) {
            throw new IllegalArgumentException("Experiment outcome must be provided.");
        }
        if (this.outcomeType == null || this.outcomeType.isEmpty()) {
            throw new IllegalArgumentException("Experiment outcomeType must be provided.");
        }
        try {
            Schema.Type type = Schema.Type.valueOf((String)this.outcomeType.toUpperCase());
            if (!VALID_TYPES.contains(type)) {
                throw new IllegalArgumentException(String.format("Experiment outcomeType '%s' is invalid. Must be one of '%s'.", this.outcomeType, Joiner.on((char)',').join(VALID_TYPES)));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Experiment outcomeType '%s' is invalid. Must be one of '%s'.", this.outcomeType, Joiner.on((char)',').join(VALID_TYPES)));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Experiment that = (Experiment)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.srcpath, that.srcpath) && Objects.equals(this.outcome, that.outcome) && Objects.equals(this.outcomeType, that.outcomeType) && Objects.equals(this.directives, that.directives);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.srcpath, this.outcome, this.outcomeType, this.directives);
    }

    public String toString() {
        return "Experiment{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", srcpath='" + this.srcpath + '\'' + ", outcome='" + this.outcome + '\'' + ", outcomeType='" + this.outcomeType + '\'' + ", directives=" + this.directives + '}';
    }
}

