/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import java.util.Objects;
import javax.annotation.Nullable;

public class EvaluationMetrics {
    private Double precision;
    private Double recall;
    private Double f1;
    private Double rmse;
    private Double r2;
    private Double evariance;
    private Double mae;

    public EvaluationMetrics(double precision, double recall, double f1) {
        this(precision, recall, f1, null, null, null, null);
    }

    public EvaluationMetrics(double rmse, double r2, double evariance, double mae) {
        this(null, null, null, rmse, r2, evariance, mae);
    }

    public EvaluationMetrics(@Nullable Double precision, @Nullable Double recall, @Nullable Double f1, @Nullable Double rmse, @Nullable Double r2, @Nullable Double evariance, @Nullable Double mae) {
        this.precision = precision;
        this.recall = recall;
        this.f1 = f1;
        this.rmse = rmse;
        this.r2 = r2;
        this.evariance = evariance;
        this.mae = mae;
    }

    @Nullable
    public Double getPrecision() {
        return this.precision;
    }

    @Nullable
    public Double getRecall() {
        return this.recall;
    }

    @Nullable
    public Double getF1() {
        return this.f1;
    }

    @Nullable
    public Double getRmse() {
        return this.rmse;
    }

    @Nullable
    public Double getR2() {
        return this.r2;
    }

    @Nullable
    public Double getEvariance() {
        return this.evariance;
    }

    @Nullable
    public Double getMae() {
        return this.mae;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluationMetrics that = (EvaluationMetrics)o;
        return Objects.equals(this.precision, that.precision) && Objects.equals(this.recall, that.recall) && Objects.equals(this.f1, that.f1) && Objects.equals(this.rmse, that.rmse) && Objects.equals(this.r2, that.r2) && Objects.equals(this.evariance, that.evariance) && Objects.equals(this.mae, that.mae);
    }

    public int hashCode() {
        return Objects.hash(this.precision, this.recall, this.f1, this.rmse, this.r2, this.evariance, this.mae);
    }
}

