/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler;

import com.google.common.collect.ImmutableList;
import io.cdap.mmds.api.Modeler;
import io.cdap.mmds.modeler.DecisionTreeClassifierModeler;
import io.cdap.mmds.modeler.DecisionTreeRegressionModeler;
import io.cdap.mmds.modeler.GBTClassifierModeler;
import io.cdap.mmds.modeler.GBTRegressionModeler;
import io.cdap.mmds.modeler.GeneralizedLinearRegressionModeler;
import io.cdap.mmds.modeler.LinearRegressionModeler;
import io.cdap.mmds.modeler.LogisticRegressionModeler;
import io.cdap.mmds.modeler.MultilayerPerceptronModeler;
import io.cdap.mmds.modeler.NaiveBayesModeler;
import io.cdap.mmds.modeler.RandomForestClassifierModeler;
import io.cdap.mmds.modeler.RandomForestRegressionModeler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class Modelers {
    private static final List<Modeler> MODELERS = ImmutableList.of((Object)new DecisionTreeRegressionModeler(), (Object)new GeneralizedLinearRegressionModeler(), (Object)new GBTRegressionModeler(), (Object)new LinearRegressionModeler(), (Object)new RandomForestRegressionModeler(), (Object)new DecisionTreeClassifierModeler(), (Object)new GBTClassifierModeler(), (Object)new LogisticRegressionModeler(), (Object)new MultilayerPerceptronModeler(), (Object)new NaiveBayesModeler(), (Object)new RandomForestClassifierModeler());
    private static final Map<String, Modeler> MODELER_MAP = MODELERS.stream().collect(Collectors.toMap(modeler -> modeler.getAlgorithm().getId(), modeler -> modeler));

    public static Collection<String> getAlgorithms() {
        return MODELER_MAP.keySet();
    }

    public static Collection<Modeler> getModelers() {
        return MODELERS;
    }

    @Nullable
    public static Modeler getModeler(String algorithm) {
        return MODELER_MAP.get(algorithm);
    }
}

